/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.terracotta.ehcachedx.org.mortbay.io.Connection;
import org.terracotta.ehcachedx.org.mortbay.io.EndPoint;
import org.terracotta.ehcachedx.org.mortbay.io.nio.SelectChannelEndPoint;
import org.terracotta.ehcachedx.org.mortbay.io.nio.SelectorManager;
import org.terracotta.ehcachedx.org.mortbay.jetty.HttpConnection;
import org.terracotta.ehcachedx.org.mortbay.jetty.Request;
import org.terracotta.ehcachedx.org.mortbay.jetty.nio.AbstractNIOConnector;
import org.terracotta.ehcachedx.org.mortbay.log.Log;

public class SelectChannelConnector
extends AbstractNIOConnector {
    protected transient ServerSocketChannel _acceptChannel;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private SelectorManager _manager = new SelectorManager(){

        protected SocketChannel acceptChannel(SelectionKey key) throws IOException {
            SocketChannel channel = ((ServerSocketChannel)key.channel()).accept();
            if (channel == null) {
                return null;
            }
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            SelectChannelConnector.this.configure(socket);
            return channel;
        }

        public boolean dispatch(Runnable task) throws IOException {
            return SelectChannelConnector.this.getThreadPool().dispatch(task);
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionClosed((HttpConnection)endpoint.getConnection());
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionOpened((HttpConnection)endpoint.getConnection());
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            return SelectChannelConnector.this.newConnection(channel, endpoint);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey sKey) throws IOException {
            return SelectChannelConnector.this.newEndPoint(channel, selectSet, sKey);
        }
    };

    public void accept(int acceptorID) throws IOException {
        this._manager.doSelect(acceptorID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._manager.isRunning()) {
                try {
                    this._manager.stop();
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
            if (this._acceptChannel != null) {
                this._acceptChannel.close();
            }
            this._acceptChannel = null;
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        ConnectorEndPoint cep = (ConnectorEndPoint)endpoint;
        cep.cancelIdle();
        request.setTimeStamp(cep.getSelectSet().getNow());
        super.customize(endpoint, request);
    }

    public void persist(EndPoint endpoint) throws IOException {
        ((ConnectorEndPoint)endpoint).scheduleIdle();
        super.persist(endpoint);
    }

    public Object getConnection() {
        return this._acceptChannel;
    }

    public boolean getDelaySelectKeyUpdate() {
        return this._manager.isDelaySelectKeyUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalPort() {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
                return -1;
            }
            return this._acceptChannel.socket().getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null) {
                this._acceptChannel = ServerSocketChannel.open();
                this._acceptChannel.socket().setReuseAddress(this.getReuseAddress());
                InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
                this._acceptChannel.configureBlocking(false);
            }
        }
    }

    public void setDelaySelectKeyUpdate(boolean delay) {
        this._manager.setDelaySelectKeyUpdate(delay);
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._manager.setMaxIdleTime(maxIdleTime);
        super.setMaxIdleTime(maxIdleTime);
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = lowResourcesConnections;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
        super.setLowResourceMaxIdleTime((int)lowResourcesMaxIdleTime);
    }

    public void setLowResourceMaxIdleTime(int lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
        super.setLowResourceMaxIdleTime(lowResourcesMaxIdleTime);
    }

    protected void doStart() throws Exception {
        this._manager.setSelectSets(this.getAcceptors());
        this._manager.setMaxIdleTime(this.getMaxIdleTime());
        this._manager.setLowResourcesConnections(this.getLowResourcesConnections());
        this._manager.setLowResourcesMaxIdleTime(this.getLowResourcesMaxIdleTime());
        this._manager.start();
        this.open();
        this._manager.register(this._acceptChannel);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return new ConnectorEndPoint(channel, selectSet, key);
    }

    protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
        return new HttpConnection(this, endpoint, this.getServer());
    }

    public static class ConnectorEndPoint
    extends SelectChannelEndPoint {
        public ConnectorEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) {
            super(channel, selectSet, key);
            this.scheduleIdle();
        }

        public void close() throws IOException {
            super.close();
        }

        public void undispatch() {
            super.undispatch();
        }
    }
}

