/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.terracotta.ehcachedx.org.mortbay.component.AbstractLifeCycle;
import org.terracotta.ehcachedx.org.mortbay.io.Connection;
import org.terracotta.ehcachedx.org.mortbay.io.EndPoint;
import org.terracotta.ehcachedx.org.mortbay.io.nio.SelectChannelEndPoint;
import org.terracotta.ehcachedx.org.mortbay.log.Log;
import org.terracotta.ehcachedx.org.mortbay.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private static final int __JVMBUG_THRESHHOLD = Integer.getInteger("org.mortbay.io.nio.JVMBUG_THRESHHOLD", 128);
    private static final int __JVMBUG_THRESHHOLD2 = __JVMBUG_THRESHHOLD * 2;
    private static final int __JVMBUG_THRESHHOLD1 = (__JVMBUG_THRESHHOLD2 + __JVMBUG_THRESHHOLD) / 2;
    private boolean _delaySelectKeyUpdate = true;
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;
    private boolean _jvmBug0;
    private boolean _jvmBug1;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public boolean isDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    public void register(SocketChannel channel, Object att) throws IOException {
        int s = this._set++;
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel, att);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) throws IOException {
        int s = this._set++;
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
    }

    public void doSelect(int acceptorID) throws IOException {
        SelectSet[] sets = this._selectSet;
        if (sets != null && sets.length > acceptorID && sets[acceptorID] != null) {
            sets[acceptorID].doSelect();
        }
    }

    public void setDelaySelectKeyUpdate(boolean delaySelectKeyUpdate) {
        this._delaySelectKeyUpdate = delaySelectKeyUpdate;
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1) throws IOException;

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (int i = 0; i < sets.length; ++i) {
                SelectSet set = sets[i];
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        Log.warn(ex);
    }

    private static interface ChangeTask {
        public void run();
    }

    private static class ChangeSelectableChannel {
        final SelectableChannel _channel;
        final Object _attachment;

        public ChangeSelectableChannel(SelectableChannel channel, Object attachment) {
            this._channel = channel;
            this._attachment = attachment;
        }
    }

    public class SelectSet {
        private transient int _change;
        private transient List[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient int _setID;
        private transient int _jvmBug;
        private volatile boolean _selecting;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout(this);
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._retryTimeout = new Timeout(this);
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void addChange(SelectableChannel channel, Object att) {
            if (att == null) {
                this.addChange(channel);
            } else if (att instanceof EndPoint) {
                this.addChange(att);
            } else {
                this.addChange(new ChangeSelectableChannel(channel, att));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void doSelect() throws IOException {
            Iterator<SelectionKey> iterator;
            Selector new_selector;
            block62: {
                SelectionKey key2 = null;
                try {
                    try {
                        long now;
                        Selector selector;
                        block66: {
                            block65: {
                                block64: {
                                    block63: {
                                        List[] listArray = this._changes;
                                        // MONITORENTER : this._changes
                                        List changes = this._changes[this._change];
                                        this._change = this._change == 0 ? 1 : 0;
                                        this._selecting = true;
                                        selector = this._selector;
                                        // MONITOREXIT : listArray
                                        for (int i = 0; i < changes.size(); ++i) {
                                            try {
                                                AbstractSelectableChannel channel;
                                                Object o = changes.get(i);
                                                if (o instanceof EndPoint) {
                                                    SelectChannelEndPoint endpoint = (SelectChannelEndPoint)o;
                                                    endpoint.doUpdateKey();
                                                    continue;
                                                }
                                                if (o instanceof Runnable) {
                                                    SelectorManager.this.dispatch((Runnable)o);
                                                    continue;
                                                }
                                                if (o instanceof ChangeSelectableChannel) {
                                                    ChangeSelectableChannel asc = (ChangeSelectableChannel)o;
                                                    SelectableChannel channel2 = asc._channel;
                                                    Object att = asc._attachment;
                                                    if (channel2 instanceof SocketChannel && ((SocketChannel)channel2).isConnected()) {
                                                        key2 = channel2.register(selector, 1, att);
                                                        SelectChannelEndPoint endpoint = SelectorManager.this.newEndPoint((SocketChannel)channel2, this, key2);
                                                        key2.attach(endpoint);
                                                        endpoint.dispatch();
                                                        continue;
                                                    }
                                                    if (!channel2.isOpen()) continue;
                                                    channel2.register(selector, 8, att);
                                                    continue;
                                                }
                                                if (o instanceof SocketChannel) {
                                                    channel = (SocketChannel)o;
                                                    if (((SocketChannel)channel).isConnected()) {
                                                        key2 = channel.register(selector, 1, null);
                                                        SelectChannelEndPoint endpoint = SelectorManager.this.newEndPoint((SocketChannel)channel, this, key2);
                                                        key2.attach(endpoint);
                                                        endpoint.dispatch();
                                                        continue;
                                                    }
                                                    channel.register(selector, 8, null);
                                                    continue;
                                                }
                                                if (o instanceof ServerSocketChannel) {
                                                    channel = (ServerSocketChannel)o;
                                                    channel.register(this.getSelector(), 16);
                                                    continue;
                                                }
                                                if (!(o instanceof ChangeTask)) throw new IllegalArgumentException(o.toString());
                                                ((ChangeTask)o).run();
                                                continue;
                                            }
                                            catch (CancelledKeyException e) {
                                                if (SelectorManager.this.isRunning()) {
                                                    Log.warn(e);
                                                    continue;
                                                }
                                                Log.debug(e);
                                            }
                                        }
                                        changes.clear();
                                        long idle_next = 0L;
                                        long retry_next = 0L;
                                        now = System.currentTimeMillis();
                                        SelectSet selectSet = this;
                                        // MONITORENTER : selectSet
                                        this._idleTimeout.setNow(now);
                                        this._retryTimeout.setNow(now);
                                        if (SelectorManager.this._lowResourcesConnections > 0L && (long)selector.keys().size() > SelectorManager.this._lowResourcesConnections) {
                                            this._idleTimeout.setDuration(SelectorManager.this._lowResourcesMaxIdleTime);
                                        } else {
                                            this._idleTimeout.setDuration(SelectorManager.this._maxIdleTime);
                                        }
                                        idle_next = this._idleTimeout.getTimeToNext();
                                        retry_next = this._retryTimeout.getTimeToNext();
                                        // MONITOREXIT : selectSet
                                        long wait = 1000L;
                                        if (idle_next >= 0L && wait > idle_next) {
                                            wait = idle_next;
                                        }
                                        if (wait > 0L && retry_next >= 0L && wait > retry_next) {
                                            wait = retry_next;
                                        }
                                        if (wait <= 10L) break block63;
                                        long before = now;
                                        int selected = selector.select(wait);
                                        now = System.currentTimeMillis();
                                        this._idleTimeout.setNow(now);
                                        this._retryTimeout.setNow(now);
                                        if (__JVMBUG_THRESHHOLD > 0 && selected == 0 && wait > (long)__JVMBUG_THRESHHOLD && now - before < wait / 2L) {
                                            ++this._jvmBug;
                                            if (this._jvmBug >= __JVMBUG_THRESHHOLD2) {
                                                SelectSet selectSet2 = this;
                                                // MONITORENTER : selectSet2
                                                if (SelectorManager.this._jvmBug1) {
                                                    Log.debug("seeing JVM BUG(s) - recreating selector");
                                                } else {
                                                    SelectorManager.this._jvmBug1 = true;
                                                    Log.debug("seeing JVM BUG(s) - recreating selector");
                                                }
                                                new_selector = Selector.open();
                                                iterator = this._selector.keys().iterator();
                                                break block62;
                                            }
                                            if (this._jvmBug == __JVMBUG_THRESHHOLD || this._jvmBug == __JVMBUG_THRESHHOLD1) {
                                                if (SelectorManager.this._jvmBug0) {
                                                    Log.debug("seeing JVM BUG(s) - cancelling interestOps==0");
                                                } else {
                                                    SelectorManager.this._jvmBug0 = true;
                                                    Log.debug("seeing JVM BUG(s) - cancelling interestOps==0");
                                                }
                                                for (SelectionKey k : selector.keys()) {
                                                    if (!k.isValid() || k.interestOps() != 0) continue;
                                                    k.cancel();
                                                }
                                                Object var36_35 = null;
                                                this._selecting = false;
                                                return;
                                            }
                                            break block64;
                                        } else {
                                            this._jvmBug = 0;
                                        }
                                        break block64;
                                    }
                                    selector.selectNow();
                                    this._jvmBug = 0;
                                }
                                if (this._selector == null) break block65;
                                if (selector.isOpen()) break block66;
                            }
                            Object var36_36 = null;
                            this._selecting = false;
                            return;
                        }
                        for (SelectionKey key2 : selector.selectedKeys()) {
                            try {
                                block68: {
                                    SocketChannel channel;
                                    Object att;
                                    block69: {
                                        block67: {
                                            if (!key2.isValid()) {
                                                key2.cancel();
                                                SelectChannelEndPoint endpoint = (SelectChannelEndPoint)key2.attachment();
                                                if (endpoint == null) continue;
                                                endpoint.doUpdateKey();
                                                continue;
                                            }
                                            att = key2.attachment();
                                            if (!(att instanceof SelectChannelEndPoint)) break block67;
                                            SelectChannelEndPoint endpoint = (SelectChannelEndPoint)att;
                                            endpoint.dispatch();
                                            break block68;
                                        }
                                        if (!key2.isAcceptable()) break block69;
                                        channel = SelectorManager.this.acceptChannel(key2);
                                        if (channel == null) continue;
                                        channel.configureBlocking(false);
                                        ++this._nextSet;
                                        this._nextSet %= SelectorManager.this._selectSet.length;
                                        if (this._nextSet == this._setID) {
                                            SelectionKey cKey = channel.register(SelectorManager.this._selectSet[this._nextSet].getSelector(), 1);
                                            SelectChannelEndPoint endpoint = SelectorManager.this.newEndPoint(channel, SelectorManager.this._selectSet[this._nextSet], cKey);
                                            cKey.attach(endpoint);
                                            if (endpoint != null) {
                                                endpoint.dispatch();
                                            }
                                            break block68;
                                        } else {
                                            SelectorManager.this._selectSet[this._nextSet].addChange(channel);
                                            SelectorManager.this._selectSet[this._nextSet].wakeup();
                                        }
                                        break block68;
                                    }
                                    if (key2.isConnectable()) {
                                        SelectChannelEndPoint endpoint;
                                        Object var33_41;
                                        channel = (SocketChannel)key2.channel();
                                        boolean connected = false;
                                        try {
                                            try {
                                                connected = channel.finishConnect();
                                            }
                                            catch (Exception e) {
                                                SelectorManager.this.connectionFailed(channel, e, att);
                                                var33_41 = null;
                                                if (connected) {
                                                    key2.interestOps(1);
                                                    endpoint = SelectorManager.this.newEndPoint(channel, this, key2);
                                                    key2.attach(endpoint);
                                                    endpoint.dispatch();
                                                }
                                                key2.cancel();
                                            }
                                            var33_41 = null;
                                            if (connected) {
                                                key2.interestOps(1);
                                                endpoint = SelectorManager.this.newEndPoint(channel, this, key2);
                                                key2.attach(endpoint);
                                                endpoint.dispatch();
                                            }
                                            key2.cancel();
                                        }
                                        catch (Throwable throwable) {
                                            var33_41 = null;
                                            if (connected) {
                                                key2.interestOps(1);
                                                endpoint = SelectorManager.this.newEndPoint(channel, this, key2);
                                                key2.attach(endpoint);
                                                endpoint.dispatch();
                                                throw throwable;
                                            }
                                            key2.cancel();
                                            throw throwable;
                                        }
                                    } else {
                                        channel = (SocketChannel)key2.channel();
                                        SelectChannelEndPoint endpoint = SelectorManager.this.newEndPoint(channel, this, key2);
                                        key2.attach(endpoint);
                                        if (key2.isReadable()) {
                                            endpoint.dispatch();
                                        }
                                    }
                                }
                                key2 = null;
                            }
                            catch (CancelledKeyException e) {
                                Log.ignore(e);
                            }
                            catch (Exception e) {
                                if (SelectorManager.this.isRunning()) {
                                    Log.warn(e);
                                } else {
                                    Log.ignore(e);
                                }
                                if (key2 == null || key2.channel() instanceof ServerSocketChannel || !key2.isValid()) continue;
                                key2.interestOps(0);
                                key2.cancel();
                            }
                        }
                        selector.selectedKeys().clear();
                        this._idleTimeout.tick(now);
                        this._retryTimeout.tick(now);
                    }
                    catch (CancelledKeyException e) {
                        Log.ignore(e);
                        Object var36_38 = null;
                        this._selecting = false;
                        return;
                    }
                    Object var36_37 = null;
                    this._selecting = false;
                    return;
                }
                catch (Throwable throwable) {
                    Object var36_39 = null;
                    this._selecting = false;
                    throw throwable;
                }
            }
            while (true) {
                if (!iterator.hasNext()) {
                    this._selector.close();
                    this._selector = new_selector;
                    this._jvmBug = 0;
                    // MONITOREXIT : selectSet2
                    Object var36_34 = null;
                    this._selecting = false;
                    return;
                }
                SelectionKey k = iterator.next();
                if (!k.isValid() || k.interestOps() == 0) continue;
                SelectableChannel channel = k.channel();
                Object attachment = k.attachment();
                if (attachment == null) {
                    this.addChange(channel);
                    continue;
                }
                this.addChange(channel, attachment);
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                if (this._idleTimeout.getDuration() <= 0L) {
                    return;
                }
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long timeout) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, timeout);
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean selecting = true;
            while (selecting) {
                this.wakeup();
                selecting = this._selecting;
            }
            ArrayList<SelectionKey> keys = new ArrayList<SelectionKey>(this._selector.keys());
            for (SelectionKey key : keys) {
                Object att;
                if (key == null || !((att = key.attachment()) instanceof EndPoint)) continue;
                EndPoint endpoint = (EndPoint)att;
                try {
                    endpoint.close();
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                selecting = this._selecting;
                while (selecting) {
                    this.wakeup();
                    selecting = this._selecting;
                }
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
                this._selector = null;
            }
        }
    }
}

