/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringUtils {
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    private static final Map<Character, String> XML_ENCODE_MAP = new HashMap<Character, String>();

    public static boolean needsUrlEncoding(String source) {
        if (null == source) {
            return false;
        }
        boolean encode = false;
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '*') continue;
            encode = true;
            break;
        }
        return encode;
    }

    public static String encodeUrl(String source) {
        if (!StringUtils.needsUrlEncoding(source)) {
            return source;
        }
        try {
            return URLEncoder.encode(source, ENCODING_ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeXml(String source) {
        return StringUtils.encode(source, XML_ENCODE_MAP);
    }

    private static String encode(String source, Map<Character, String> ... encodingTables) {
        if (null == source) {
            return null;
        }
        if (null == encodingTables || 0 == encodingTables.length) {
            return source;
        }
        StringBuilder encodedString = null;
        char[] stringToEncodeArray = source.toCharArray();
        int last_match = -1;
        for (int i = 0; i < stringToEncodeArray.length; ++i) {
            char charToEncode = stringToEncodeArray[i];
            for (Map<Character, String> encodingTable : encodingTables) {
                if (!encodingTable.containsKey(Character.valueOf(charToEncode))) continue;
                encodedString = StringUtils.prepareEncodedString(source, encodedString, i, last_match, stringToEncodeArray);
                encodedString.append(encodingTable.get(Character.valueOf(charToEncode)));
                last_match = i;
            }
        }
        if (null == encodedString) {
            return source;
        }
        int difference = stringToEncodeArray.length - (last_match + 1);
        if (difference > 0) {
            encodedString.append(stringToEncodeArray, last_match + 1, difference);
        }
        return encodedString.toString();
    }

    private static StringBuilder prepareEncodedString(String source, StringBuilder encodedString, int i, int lastMatch, char[] stringToEncodeArray) {
        int difference;
        if (null == encodedString) {
            encodedString = new StringBuilder(source.length());
        }
        if ((difference = i - (lastMatch + 1)) > 0) {
            encodedString.append(stringToEncodeArray, lastMatch + 1, difference);
        }
        return encodedString;
    }

    public static String repeat(String source, int count) {
        if (null == source) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        while (count > 0) {
            result.append(source);
            --count;
        }
        return result.toString();
    }

    public static Integer convertToInt(String str) {
        Integer result = null;
        if (str != null && str.length() != 0) {
            result = new Integer(str);
        }
        return result;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toUpperCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String addMethodNamePrefix(String methodName, String prefix) {
        if (prefix != null && prefix.length() > 0) {
            methodName = prefix + StringUtils.capitalize(methodName);
        }
        return methodName;
    }

    public static String removeMethodNamePrefix(String methodName, String prefix) {
        if (prefix != null && prefix.length() > 0 && methodName != null && methodName.startsWith(prefix)) {
            methodName = StringUtils.uncapitalize(methodName.substring(prefix.length()));
        }
        return methodName;
    }

    public static String introduceDecimals(String valueWithoutDecimals, int decimals) {
        if (decimals <= 0) {
            return valueWithoutDecimals;
        }
        String valueWithDecimals = valueWithoutDecimals.length() <= decimals ? "0." + valueWithoutDecimals : valueWithoutDecimals.substring(0, valueWithoutDecimals.length() - decimals) + '.' + valueWithoutDecimals.substring(valueWithoutDecimals.length() - decimals);
        return valueWithDecimals;
    }

    public static String secondsToFormattedTime(long elapsedTime) {
        String format = String.format("%%0%dd", 2);
        String seconds = String.format(format, elapsedTime % 60L);
        String minutes = String.format(format, elapsedTime % 3600L / 60L);
        String hours = String.format(format, elapsedTime / 3600L);
        return hours + ":" + minutes + ":" + seconds;
    }

    static {
        XML_ENCODE_MAP.put(Character.valueOf('&'), "&amp;");
        XML_ENCODE_MAP.put(Character.valueOf('\''), "&apos;");
        XML_ENCODE_MAP.put(Character.valueOf('\"'), "&quot;");
        XML_ENCODE_MAP.put(Character.valueOf('<'), "&lt;");
        XML_ENCODE_MAP.put(Character.valueOf('>'), "&gt;");
    }
}

