/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe.counter.sampled.memory;

import java.lang.reflect.Field;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinitionMap;
import org.terracotta.ehcachedx.com.javabi.sizeof.IdentityHashSet;
import org.terracotta.ehcachedx.com.javabi.sizeof.MemoryUtil;
import org.terracotta.org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.terracotta.org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;

public class MemorySamplerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MemorySamplerSupport.class);
    private static final int WINDOW_SIZE = 100;
    private final DescriptiveStatistics stats;
    private final boolean memoryMeasurement;

    public MemorySamplerSupport(boolean memoryMeasurement) {
        this.memoryMeasurement = memoryMeasurement;
        this.stats = new SynchronizedDescriptiveStatistics(100);
    }

    public void notifyMemorySampler(Ehcache ehcache, Element element, Long counter) {
        if (this.shouldSample(ehcache, counter)) {
            this.sample(ehcache, element);
        }
    }

    public boolean shouldSample(Ehcache ehcache, Long putCounter) {
        return putCounter % 100L == 0L || putCounter <= 15L;
    }

    public Long getLastAdjustedSample() {
        return Math.round(this.stats.getPercentile(97.0));
    }

    public DescriptiveStatistics getStatistics() {
        return this.stats;
    }

    protected void recordValue(long size) {
        if (size != 0L) {
            this.stats.addValue(size);
        } else {
            this.stats.clear();
        }
    }

    private long sample(Ehcache ehcache, Element obj) {
        long val = 0L;
        val = ehcache.getCacheConfiguration().isTerracottaClustered() ? this.tcEstimateSize(obj) : this.estimateSize(obj);
        this.recordValue(val);
        return val;
    }

    protected long estimateSize(Object object) {
        long valueInBytes = 0L;
        if (!this.memoryMeasurement) {
            return 0L;
        }
        try {
            valueInBytes = MemoryUtil.sizeOf(object);
        }
        catch (Throwable t) {
            LOG.debug("Could not calculate memory for object " + object + ". Returning 0", t);
        }
        return valueInBytes;
    }

    private Field getField(Object o, String name) {
        for (Field f : o.getClass().getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    protected long tcEstimateSize(Element element) {
        long valueInBytes = 0L;
        if (!this.memoryMeasurement) {
            return 0L;
        }
        try {
            ClassDefinitionMap definitionMap = new ClassDefinitionMap(){

                public final boolean shouldIgnoreField(Field field) {
                    if (field.getName().startsWith("$__tc_")) {
                        return true;
                    }
                    return super.shouldIgnoreField(field);
                }
            };
            Field field = null;
            try {
                Field elementEvictionData = this.getField(element, "elementEvictionData");
                if (elementEvictionData != null) {
                    elementEvictionData.setAccessible(true);
                    Object evd = elementEvictionData.get(element);
                    field = this.getField(evd, "store");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (field != null) {
                definitionMap.ignoreField(field);
            }
            valueInBytes += MemoryUtil.sizeOf(element, definitionMap, new IdentityHashSet());
        }
        catch (Throwable t) {
            LOG.debug("Could not calculate memory for Element " + element + ". Returning 0", t);
        }
        return valueInBytes;
    }
}

