/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe.counter.sampled.memory;

import java.util.IdentityHashMap;
import java.util.Map;

public class MemoryConfig {
    public int INSTANCE_OVERHEAD;
    public boolean COUNT_INSTANCE_OVERHEAD;
    private boolean COUNT_REFS;
    private int REFERENCE_SIZE;
    private final Map primitiveSizes = new IdentityHashMap<Class, Integer>(){
        {
            this.put(Boolean.TYPE, new Integer(1));
            this.put(Boolean.class, new Integer(1));
            this.put(Character.TYPE, new Integer(2));
            this.put(Character.class, new Integer(2));
            this.put(Byte.TYPE, new Integer(1));
            this.put(Byte.class, new Integer(1));
            this.put(Short.TYPE, new Integer(2));
            this.put(Short.class, new Integer(2));
            this.put(Integer.TYPE, new Integer(4));
            this.put(Integer.class, new Integer(4));
            this.put(Float.TYPE, new Integer(4));
            this.put(Float.class, new Integer(4));
            this.put(Long.TYPE, new Integer(8));
            this.put(Long.class, new Integer(8));
            this.put(Double.TYPE, new Integer(8));
            this.put(Double.class, new Integer(8));
        }
    };

    public int getInstanceOverhead() {
        return this.COUNT_INSTANCE_OVERHEAD ? this.INSTANCE_OVERHEAD : 0;
    }

    public Integer getPrimitiveSize(Class clazz) {
        return (Integer)this.primitiveSizes.get(clazz);
    }

    public int getRefSize() {
        if (this.COUNT_REFS) {
            return this.REFERENCE_SIZE;
        }
        return 0;
    }

    public MemoryConfig() {
        this.REFERENCE_SIZE = 8;
        this.COUNT_REFS = true;
        this.INSTANCE_OVERHEAD = 40;
    }

    public MemoryConfig(boolean countRefs, boolean countInstanceOverhead) {
        this.COUNT_REFS = countRefs;
        this.COUNT_INSTANCE_OVERHEAD = countInstanceOverhead;
    }
}

