/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

import java.util.Collections;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.terracotta.ehcachedx.monitor.probe.CacheManagerService;
import org.terracotta.ehcachedx.monitor.probe.SampleHistoryEntry;
import org.terracotta.ehcachedx.monitor.probe.SampledCacheStatistics;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.SampledCounter;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.TimeStampedCounterValue;
import org.terracotta.ehcachedx.monitor.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Statistic {
    removed,
    put,
    updated,
    expired,
    evicted,
    hit,
    hitMemory,
    hitOffHeap,
    hitDisk,
    hitRatio(true),
    offHeapUsage(true),
    miss,
    missMemory,
    missOffHeap,
    missDisk,
    totalCount(0){

        long normalize(SampledCacheStatistics stats, long value) {
            return value;
        }
    }
    ,
    diskCount(0){

        long normalize(SampledCacheStatistics stats, long value) {
            return value;
        }
    }
    ,
    offHeapCount(0){

        long normalize(SampledCacheStatistics stats, long value) {
            return value;
        }
    }
    ,
    memoryCount(0){

        long normalize(SampledCacheStatistics stats, long value) {
            return value;
        }
    }
    ,
    memorySize(0){

        long normalize(SampledCacheStatistics stats, long value) {
            return value;
        }
    }
    ,
    offHeapSize(0){

        long normalize(SampledCacheStatistics stats, long value) {
            return value;
        }
    }
    ,
    offHeapUsed(0){

        long normalize(SampledCacheStatistics stats, long value) {
            return value;
        }
    };

    private static final SortedSet<String> NAMES;
    private boolean average;
    private int decimals;

    public static SortedSet<String> getNames() {
        return NAMES;
    }

    private Statistic() {
        this(1, false);
    }

    private Statistic(int decimals) {
        this(decimals, false);
    }

    private Statistic(boolean average) {
        this(1, average);
    }

    private Statistic(int decimals, boolean average) {
        this.decimals = decimals;
        this.average = average;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean isAverage() {
        return this.average;
    }

    long normalize(SampledCacheStatistics stats, long value) {
        return value * 10L / (long)stats.getCounterConfig().getIntervalSecs();
    }

    private String convertSample(SampledCacheStatistics stats, long value) {
        String valueWithoutDecimals = String.valueOf(this.normalize(stats, value));
        return StringUtils.introduceDecimals(valueWithoutDecimals, this.decimals);
    }

    String getSample(SampledCacheStatistics stats) {
        SampledCounter counter = stats.getCounters().get((Object)this);
        if (null == counter) {
            return null;
        }
        long value = counter.getMostRecentSample().getCounterValue();
        return this.convertSample(stats, value);
    }

    SampleHistoryEntry[] getSampleHistory(SampledCacheStatistics stats) {
        SampledCounter counter = stats.getCounters().get((Object)this);
        TimeStampedCounterValue[] values = counter.getAllSampleValues();
        SampleHistoryEntry[] result = new SampleHistoryEntry[values.length];
        for (int i = 0; i < values.length; ++i) {
            TimeStampedCounterValue value = values[values.length - (i + 1)];
            result[i] = new SampleHistoryEntry(this.convertSample(stats, value.getCounterValue()), CacheManagerService.createMetaDataDateFormat().format(new Date(value.getTimeStamp())));
        }
        return result;
    }

    static {
        TreeSet<String> names = new TreeSet<String>();
        for (Statistic name : Statistic.values()) {
            names.add(name.name());
        }
        NAMES = Collections.unmodifiableSortedSet(names);
    }
}

