/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.terracotta.ehcachedx.monitor.probe.SampleHistoryEntry;
import org.terracotta.ehcachedx.monitor.probe.SampleRange;
import org.terracotta.ehcachedx.monitor.probe.Statistic;
import org.terracotta.ehcachedx.monitor.probe.counter.CounterManager;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.PullSampledCounterConfig;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.SampledCounter;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.SampledCounterConfig;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.memory.CacheMemorySizeCalculator;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.memory.MemorySamplerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledCacheStatistics {
    private final SampledCounterConfig counterConfig;
    private final SampledCounter removedCounter;
    private final SampledCounter putCounter;
    private final SampledCounter updatedCounter;
    private final SampledCounter expiredCounter;
    private final SampledCounter evictedCounter;
    private final SampledCounter hitCounter;
    private final SampledCounter hitMemoryCounter;
    private final SampledCounter hitOffHeapCounter;
    private final SampledCounter hitDiskCounter;
    private final SampledCounter hitRatioCounter;
    private final SampledCounter offHeapUsageCounter;
    private final SampledCounter offHeapUsedCounter;
    private final SampledCounter offHeapSizeCounter;
    private final SampledCounter missCounter;
    private final SampledCounter missMemoryCounter;
    private final SampledCounter missOffHeapCounter;
    private final SampledCounter missDiskCounter;
    private final SampledCounter totalCountCounter;
    private final SampledCounter diskCountCounter;
    private final SampledCounter offHeapCountCounter;
    private final SampledCounter memoryCountCounter;
    private final SampledCounter memorySizeCounter;
    private boolean memoryMeasurement;
    private final MemorySamplerSupport memorySamplerSupport;
    private static final Long UNAVAILABLE_VALUE = 0L;
    private final Map<Statistic, SampledCounter> counters;

    public Map<Statistic, SampledCounter> getCounters() {
        return this.counters;
    }

    public SampledCacheStatistics(final Ehcache cache, CounterManager counterManager, SampledCounterConfig counterConfig, boolean memoryMeasurement) {
        this.counterConfig = counterConfig;
        this.memoryMeasurement = memoryMeasurement;
        this.memorySamplerSupport = new MemorySamplerSupport(memoryMeasurement);
        this.removedCounter = (SampledCounter)counterManager.createCounter(counterConfig);
        this.putCounter = (SampledCounter)counterManager.createCounter(counterConfig);
        this.updatedCounter = (SampledCounter)counterManager.createCounter(counterConfig);
        this.expiredCounter = (SampledCounter)counterManager.createCounter(counterConfig);
        this.evictedCounter = (SampledCounter)counterManager.createCounter(counterConfig);
        this.hitCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, true, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return cache.getStatistics().getCacheHits();
            }
        }));
        this.hitMemoryCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, true, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return cache.getStatistics().getInMemoryHits();
            }
        }));
        this.hitOffHeapCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, true, new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    return cache.getStatistics().getOffHeapHits();
                }
                catch (NoSuchMethodError e) {
                    return UNAVAILABLE_VALUE;
                }
            }
        }));
        this.hitDiskCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, true, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return cache.getStatistics().getOnDiskHits();
            }
        }));
        this.hitRatioCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new Callable<Long>(){
            private long previousHits = 0L;
            private long previousMisses = 0L;

            @Override
            public Long call() throws Exception {
                long currentHits = cache.getStatistics().getCacheHits();
                long currentMisses = cache.getStatistics().getCacheMisses();
                long hitsDelta = currentHits - this.previousHits;
                long missesDelta = currentMisses - this.previousMisses;
                this.previousHits = currentHits;
                this.previousMisses = currentMisses;
                long total = hitsDelta + missesDelta;
                if (0L == total) {
                    return 0L;
                }
                Long result = 1000L * hitsDelta / total;
                return result;
            }
        }));
        this.offHeapUsageCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    long used = cache.calculateOffHeapSize();
                    long total = cache.getCacheConfiguration().getMaxMemoryOffHeapInBytes();
                    double d = (double)used / (double)total;
                    return (long)(d * 1000.0);
                }
                catch (NoSuchMethodError e) {
                    return UNAVAILABLE_VALUE;
                }
            }
        }));
        this.offHeapUsedCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    return cache.calculateOffHeapSize();
                }
                catch (NoSuchMethodError e) {
                    return UNAVAILABLE_VALUE;
                }
            }
        }));
        this.offHeapSizeCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    return cache.getCacheConfiguration().getMaxMemoryOffHeapInBytes();
                }
                catch (NoSuchMethodError e) {
                    return UNAVAILABLE_VALUE;
                }
            }
        }));
        this.missCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, true, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return cache.getStatistics().getCacheMisses();
            }
        }));
        this.missMemoryCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, true, new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    return cache.getStatistics().getInMemoryMisses();
                }
                catch (NoSuchMethodError e) {
                    return UNAVAILABLE_VALUE;
                }
            }
        }));
        this.missOffHeapCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, true, new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    return cache.getStatistics().getOffHeapMisses();
                }
                catch (NoSuchMethodError e) {
                    return UNAVAILABLE_VALUE;
                }
            }
        }));
        this.missDiskCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, true, new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    return cache.getStatistics().getOnDiskMisses();
                }
                catch (NoSuchMethodError e) {
                    return UNAVAILABLE_VALUE;
                }
            }
        }));
        this.totalCountCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return cache.getSize();
            }
        }));
        this.diskCountCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return cache.getDiskStoreSize();
            }
        }));
        this.offHeapCountCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    return cache.getOffHeapStoreSize();
                }
                catch (NoSuchMethodError e) {
                    return UNAVAILABLE_VALUE;
                }
            }
        }));
        this.memoryCountCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return cache.getMemoryStoreSize();
            }
        }));
        this.memorySizeCounter = (SampledCounter)counterManager.createCounter(new PullSampledCounterConfig(counterConfig, false, new CacheMemorySizeCalculator(cache, this.memorySamplerSupport.getStatistics())));
        this.counters = new HashMap<Statistic, SampledCounter>();
        this.counters.put(Statistic.removed, this.removedCounter);
        this.counters.put(Statistic.put, this.putCounter);
        this.counters.put(Statistic.updated, this.updatedCounter);
        this.counters.put(Statistic.expired, this.expiredCounter);
        this.counters.put(Statistic.evicted, this.evictedCounter);
        this.counters.put(Statistic.hit, this.hitCounter);
        this.counters.put(Statistic.hitMemory, this.hitMemoryCounter);
        this.counters.put(Statistic.hitOffHeap, this.hitOffHeapCounter);
        this.counters.put(Statistic.hitDisk, this.hitDiskCounter);
        this.counters.put(Statistic.hitRatio, this.hitRatioCounter);
        this.counters.put(Statistic.offHeapUsage, this.offHeapUsageCounter);
        this.counters.put(Statistic.offHeapUsed, this.offHeapUsedCounter);
        this.counters.put(Statistic.offHeapSize, this.offHeapSizeCounter);
        this.counters.put(Statistic.miss, this.missCounter);
        this.counters.put(Statistic.missMemory, this.missMemoryCounter);
        this.counters.put(Statistic.missOffHeap, this.missOffHeapCounter);
        this.counters.put(Statistic.missDisk, this.missDiskCounter);
        this.counters.put(Statistic.totalCount, this.totalCountCounter);
        this.counters.put(Statistic.diskCount, this.diskCountCounter);
        this.counters.put(Statistic.offHeapCount, this.offHeapCountCounter);
        this.counters.put(Statistic.memoryCount, this.memoryCountCounter);
        this.counters.put(Statistic.memorySize, this.memorySizeCounter);
        if (Statistic.values().length != this.counters.size()) {
            throw new AssertionError((Object)"Implementation error: not all SampledCacheStatistics names have been registered with a counter");
        }
    }

    public void dispose() {
        this.removedCounter.shutdown();
        this.putCounter.shutdown();
        this.updatedCounter.shutdown();
        this.expiredCounter.shutdown();
        this.evictedCounter.shutdown();
        this.hitCounter.shutdown();
        this.hitMemoryCounter.shutdown();
        this.hitOffHeapCounter.shutdown();
        this.hitDiskCounter.shutdown();
        this.hitRatioCounter.shutdown();
        this.offHeapUsageCounter.shutdown();
        this.offHeapUsedCounter.shutdown();
        this.offHeapSizeCounter.shutdown();
        this.missCounter.shutdown();
        this.missMemoryCounter.shutdown();
        this.missOffHeapCounter.shutdown();
        this.missDiskCounter.shutdown();
        this.totalCountCounter.shutdown();
        this.diskCountCounter.shutdown();
        this.offHeapCountCounter.shutdown();
        this.memoryCountCounter.shutdown();
        this.memorySizeCounter.shutdown();
    }

    public String getSample(String name) {
        Statistic nameInstance;
        try {
            nameInstance = Statistic.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return nameInstance.getSample(this);
    }

    public SampleHistoryEntry[] getAggregatedSampleHistory(String name, long fromTimeSeconds, int timeInterval, int sampleRate, int offset) {
        SampleHistoryEntry[] history = this.getSampleHistory(name);
        SampleRange sampleRange = new SampleRange(fromTimeSeconds, timeInterval, sampleRate, offset, history.length - 1);
        SampleHistoryEntry[] result = new SampleHistoryEntry[sampleRange.getNumSamples()];
        System.arraycopy(history, sampleRange.getFirstSample(), result, 0, sampleRange.getNumSamples());
        return result;
    }

    public SampleHistoryEntry[] getSampleHistory(String name) {
        Statistic nameInstance;
        try {
            nameInstance = Statistic.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return nameInstance.getSampleHistory(this);
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        this.removedCounter.increment();
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        this.putCounter.increment();
        this.memorySamplerSupport.notifyMemorySampler(ehcache, element, this.putCounter.getValue());
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        this.updatedCounter.increment();
        this.memorySamplerSupport.notifyMemorySampler(ehcache, element, this.putCounter.getValue());
    }

    public void notifyElementExpired(Ehcache ehcache, Element element) {
        this.expiredCounter.increment();
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
        this.evictedCounter.increment();
    }

    public void notifyRemoveAll(Ehcache ehcache) {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public SampledCounterConfig getCounterConfig() {
        return this.counterConfig;
    }
}

