/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

import java.sql.Date;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.ehcache.Element;
import org.terracotta.ehcachedx.monitor.probe.CacheManagerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementMetaData {
    private static final SortedSet<String> NAMES;

    public static String getMetaData(String name, Element element) {
        String result;
        try {
            MetaData metaData = MetaData.valueOf(name);
            result = metaData.getMetaData(element);
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        return result;
    }

    public static SortedSet<String> getNames() {
        return NAMES;
    }

    static {
        TreeSet<String> names = new TreeSet<String>();
        for (MetaData metaData : MetaData.values()) {
            names.add(metaData.name());
        }
        NAMES = Collections.unmodifiableSortedSet(names);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MetaData {
        valueType{

            public String getMetaData(Element element) {
                if (element.getObjectValue() != null) {
                    return element.getObjectValue().getClass().getName();
                }
                return "";
            }
        }
        ,
        created{

            public String getMetaData(Element element) {
                return this.formatTimestamp(element.getCreationTime());
            }
        }
        ,
        accessed{

            public String getMetaData(Element element) {
                return this.formatTimestamp(element.getLastAccessTime());
            }
        }
        ,
        updated{

            public String getMetaData(Element element) {
                return this.formatTimestamp(element.getLastUpdateTime());
            }
        }
        ,
        expired{

            public String getMetaData(Element element) {
                return String.valueOf(element.isExpired());
            }
        }
        ,
        eternal{

            public String getMetaData(Element element) {
                return String.valueOf(element.isEternal());
            }
        }
        ,
        timeToIdle{

            public String getMetaData(Element element) {
                return String.valueOf(element.getTimeToIdle());
            }
        }
        ,
        timeToLive{

            public String getMetaData(Element element) {
                return String.valueOf(element.getTimeToLive());
            }
        }
        ,
        expirationTime{

            public String getMetaData(Element element) {
                if (Long.MAX_VALUE == element.getExpirationTime()) {
                    return "";
                }
                return this.formatTimestamp(element.getExpirationTime());
            }
        }
        ,
        hits{

            public String getMetaData(Element element) {
                return String.valueOf(element.getHitCount());
            }
        };


        public abstract String getMetaData(Element var1);

        protected String formatTimestamp(long timestamp) {
            if (0L == timestamp) {
                return "";
            }
            return CacheManagerService.createMetaDataDateFormat().format(new Date(timestamp));
        }
    }
}

