/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common.rest;

import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.terracotta.ehcachedx.monitor.common.rest.ResponseElement;
import org.terracotta.ehcachedx.monitor.util.StringUtils;

class XmlDocumentState {
    private static final String DEFAULT_ELEMENT_NAME = "data";
    private final StringBuilder result = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    private final Pattern xmlProcessingInstruction = Pattern.compile("<\\?[^<>]*\\?>(\\n*)", 8);
    private Stack<List<ResponseElement>> childrenStack;
    private Stack<int[]> childCounter;
    private Stack<String> namesStack;

    XmlDocumentState(ResponseElement root) {
        if (root.hasChildren()) {
            this.childrenStack = new Stack();
            this.childCounter = new Stack();
            this.namesStack = new Stack();
            this.push(root);
        } else {
            this.appendValue(root);
        }
    }

    boolean isEmpty() {
        return null == this.childrenStack || this.childrenStack.isEmpty();
    }

    boolean hasChild() {
        return this.childrenStack != null && !this.childrenStack.isEmpty() && !this.childrenStack.peek().isEmpty();
    }

    boolean consumeChild() {
        int[] nArray = this.childCounter.peek();
        nArray[0] = nArray[0] + 1;
        ResponseElement child = this.childrenStack.peek().remove(0);
        if (child.hasValue()) {
            this.appendValue(child);
            return false;
        }
        if (child.hasChildren()) {
            this.push(child);
            return true;
        }
        return false;
    }

    void advance() {
        while (this.childrenStack.peek().isEmpty()) {
            this.childrenStack.pop();
            this.childCounter.pop();
            this.result.append(StringUtils.repeat("    ", this.childrenStack.size())).append("</").append(this.namesStack.pop()).append(">").append("\n");
            if (!this.childrenStack.isEmpty()) continue;
            break;
        }
    }

    private int size() {
        if (null == this.childrenStack) {
            return 0;
        }
        return this.childrenStack.size();
    }

    private String buildElementName(ResponseElement element) {
        String elementName = element.getName();
        if (null == elementName && element.hasParent()) {
            elementName = element.getParent().getChildType();
        }
        if (null == elementName) {
            elementName = this.childCounter != null && !this.childCounter.isEmpty() ? DEFAULT_ELEMENT_NAME + this.childCounter.peek()[0] : DEFAULT_ELEMENT_NAME;
        }
        return elementName;
    }

    private void push(ResponseElement current) {
        if (!current.hasChildren()) {
            throw new AssertionError((Object)"children are required");
        }
        this.result.append(StringUtils.repeat("    ", this.size()));
        String elementName = this.buildElementName(current);
        this.result.append("<").append(elementName).append(">").append("\n");
        this.namesStack.push(elementName);
        this.childrenStack.push(current.getChildren());
        this.childCounter.push(new int[]{0});
    }

    private void appendValue(ResponseElement child) {
        if (child.hasChildren()) {
            throw new AssertionError((Object)"there aren't supposed to be any children");
        }
        this.result.append(StringUtils.repeat("    ", this.size()));
        String childName = this.buildElementName(child);
        this.result.append("<").append(childName).append(">");
        if (child.hasValue()) {
            if (child.hasRawValue()) {
                this.appendRawValue(child);
            } else {
                this.appendSingleValue(child);
            }
        }
        this.result.append("</").append(childName).append(">").append("\n");
    }

    private void appendRawValue(ResponseElement child) {
        this.result.append("\n");
        String value = String.valueOf(child.getValue());
        if (value.length() > 0) {
            value = this.xmlProcessingInstruction.matcher(value).replaceAll("");
            for (String line : value.split("\n")) {
                this.result.append(StringUtils.repeat("    ", this.size() + 1));
                this.result.append(line);
                this.result.append("\n");
            }
            this.result.append(StringUtils.repeat("    ", this.size()));
        }
    }

    private void appendSingleValue(ResponseElement child) {
        this.result.append(StringUtils.encodeXml(String.valueOf(child.getValue())));
    }

    public String result() {
        return this.result.toString();
    }
}

