/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common.rest;

import java.util.ArrayList;
import java.util.Map;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletRequest;
import org.terracotta.ehcachedx.monitor.common.rest.ResponseType;

public class RestRequest {
    public static final String FORMAT_PARAMETER_NAME = "format";
    private final HttpServletRequest request;

    public RestRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public String[] getParametersAndValuesForResponseType(ResponseType type) {
        String[] paramsAndValues = this.getParametersAndValues();
        boolean formatSet = false;
        for (int i = 0; i < paramsAndValues.length && !formatSet; ++i) {
            if (!FORMAT_PARAMETER_NAME.equals(paramsAndValues[i])) continue;
            paramsAndValues[++i] = type.name().toLowerCase();
            formatSet = true;
        }
        if (!formatSet) {
            String[] paramsAndValuesNew = new String[paramsAndValues.length + 2];
            System.arraycopy(paramsAndValues, 0, paramsAndValuesNew, 2, paramsAndValues.length);
            paramsAndValuesNew[0] = FORMAT_PARAMETER_NAME;
            paramsAndValuesNew[1] = type.name().toLowerCase();
            paramsAndValues = paramsAndValuesNew;
        }
        return paramsAndValues;
    }

    public String[] getParametersAndValues() {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Map.Entry entry : this.request.getParameterMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                resultList.add(entry.getKey());
                resultList.add(value);
            }
        }
        String[] result = new String[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }
}

