/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.terracotta.ehcachedx.javax.servlet.ServletException;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletRequest;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletResponse;
import org.terracotta.ehcachedx.monitor.common.handler.RestHandler;
import org.terracotta.ehcachedx.monitor.common.rest.RestMethodInfo;
import org.terracotta.ehcachedx.monitor.common.rest.Visibility;
import org.terracotta.ehcachedx.monitor.util.HandlerUtils;
import org.terracotta.ehcachedx.org.mortbay.jetty.Handler;
import org.terracotta.ehcachedx.org.mortbay.jetty.handler.HandlerList;

public class RestHandlerList
extends HandlerList {
    public static final String LIST_METHODS_PATH = "/list";

    public void handle(String path, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (!HandlerUtils.isTarget(path)) {
            return;
        }
        String pathInfo = HandlerUtils.filterPathInfo(request.getPathInfo());
        if (LIST_METHODS_PATH.equals(pathInfo)) {
            this.outputMethods(response);
        }
        super.handle(path, request, response, dispatch);
    }

    private void outputMethods(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>API</title>");
        out.println("<style type=\"text/css\">");
        out.println("a {text-decoration: none}");
        out.println("a:hover {text-decoration: underline}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<p>The Ehcache API is HTTP GET based with a path and a query string, which are listed below. Optional parameters are marked with a [].</p><br>");
        out.println("<ul>");
        TreeMap<String, RestMethodInfo> methods = new TreeMap<String, RestMethodInfo>();
        for (Handler handler : this.getHandlers()) {
            if (!(handler instanceof RestHandler)) continue;
            RestHandler restHandler = (RestHandler)handler;
            methods.putAll(restHandler.getMethods());
        }
        for (Map.Entry entry : methods.entrySet()) {
            if (!Visibility.PUBLIC.equals((Object)((RestMethodInfo)entry.getValue()).getVisibility())) continue;
            out.print("<li>");
            String methodUrl = "/monitor/" + (String)entry.getKey();
            out.print("<a href=\"" + methodUrl + "\"");
            out.print("onclick=\"window.open('" + methodUrl + "'); return false;\" target=\"_blank\" " + "title=\"" + ((RestMethodInfo)entry.getValue()).getDescription() + "\">");
            out.print((String)entry.getKey());
            out.print("( ");
            boolean first = true;
            if (((RestMethodInfo)entry.getValue()).getRequired() != null) {
                for (String required : ((RestMethodInfo)entry.getValue()).getRequired()) {
                    if (required == null) continue;
                    if (!first) {
                        out.print(", ");
                    }
                    out.print(required);
                    first = false;
                }
            }
            if (((RestMethodInfo)entry.getValue()).getOptional() != null) {
                for (String optional : ((RestMethodInfo)entry.getValue()).getOptional()) {
                    if (optional == null) continue;
                    if (!first) {
                        out.print(", ");
                    }
                    out.print("[");
                    out.print(optional);
                    out.print("]");
                    first = false;
                }
            }
            out.print(" )");
            out.print("</a>");
            out.println("</li>");
        }
        out.println("</ul>");
        out.println("</body></html>");
        out.close();
        response.setStatus(200);
    }
}

