/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.javax.servlet.ServletException;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletRequest;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletResponse;
import org.terracotta.ehcachedx.monitor.common.handler.RequiredParameterException;
import org.terracotta.ehcachedx.monitor.common.rest.ResponseBuilder;
import org.terracotta.ehcachedx.monitor.common.rest.ResponseType;
import org.terracotta.ehcachedx.monitor.common.rest.RestMethod;
import org.terracotta.ehcachedx.monitor.common.rest.RestMethodInfo;
import org.terracotta.ehcachedx.monitor.common.rest.RestRequest;
import org.terracotta.ehcachedx.monitor.common.rest.RestResponse;
import org.terracotta.ehcachedx.monitor.common.rest.TextResponseBuilder;
import org.terracotta.ehcachedx.monitor.util.ExceptionUtils;
import org.terracotta.ehcachedx.monitor.util.HandlerUtils;
import org.terracotta.ehcachedx.monitor.util.StringUtils;
import org.terracotta.ehcachedx.org.mortbay.jetty.Request;
import org.terracotta.ehcachedx.org.mortbay.jetty.handler.AbstractHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestHandler<T>
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RestHandler.class);
    public static final String FORMAT_PARAMETER_NAME = "format";
    private static final String GETTER_PREFIX = "get";
    protected final T target;
    protected final String methodNamePrefix;

    public RestHandler(T target) {
        this(target, null);
    }

    public RestHandler(T target, String methodNamePrefix) {
        this.target = target;
        this.methodNamePrefix = methodNamePrefix;
    }

    @Override
    public void handle(String path, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (!HandlerUtils.isTarget(path)) {
            return;
        }
        String pathInfo = HandlerUtils.filterPathInfo(request.getPathInfo());
        String methodName = pathInfo.substring(1);
        this.handleMethod(request, response, methodName);
    }

    protected void handleMethod(HttpServletRequest request, HttpServletResponse response, String methodName) throws IOException, ServletException {
        ResponseBuilder responseBuilder = this.determineResponseBuilder(request);
        RestResponse restResponse = this.handleRestMethod(request, response, methodName, responseBuilder);
        if (restResponse != null) {
            restResponse.outputResponse();
            ((Request)request).setHandled(true);
        }
    }

    protected RestResponse handleRestMethod(HttpServletRequest request, HttpServletResponse response, String methodName, ResponseBuilder responseBuilder) throws ServletException {
        RestResponse restResponse;
        block12: {
            if (this.methodNamePrefix != null && this.methodNamePrefix.length() > 0 && !methodName.startsWith(this.methodNamePrefix)) {
                return null;
            }
            methodName = StringUtils.removeMethodNamePrefix(methodName, this.methodNamePrefix);
            restResponse = null;
            try {
                RestMethod annotation;
                Method method = null;
                try {
                    method = this.target.getClass().getDeclaredMethod(methodName, RestResponse.class);
                    annotation = this.detectAndValidateAnnotation(request, method);
                    if (null == annotation) {
                        method = null;
                    } else {
                        restResponse = this.buildRestResponse(response, methodName, responseBuilder);
                        method.invoke(this.target, restResponse);
                    }
                }
                catch (NoSuchMethodException e) {
                    restResponse = null;
                }
                if (null != method) break block12;
                try {
                    method = this.target.getClass().getDeclaredMethod(methodName, RestRequest.class, RestResponse.class);
                    annotation = this.detectAndValidateAnnotation(request, method);
                    if (null != annotation) {
                        restResponse = this.buildRestResponse(response, methodName, responseBuilder);
                        method.invoke(this.target, new RestRequest(request), restResponse);
                    }
                }
                catch (NoSuchMethodException e) {
                    restResponse = null;
                }
            }
            catch (RequiredParameterException e) {
                this.outputError(response, e.getMessage());
                ((Request)request).setHandled(true);
                return null;
            }
            catch (InvocationTargetException e) {
                this.outputException(response, e.getTargetException());
                ((Request)request).setHandled(true);
                return null;
            }
            catch (IllegalAccessException e) {
                this.outputException(response, e);
                ((Request)request).setHandled(true);
                return null;
            }
        }
        return restResponse;
    }

    private RestMethod detectAndValidateAnnotation(HttpServletRequest request, Method method) throws RequiredParameterException {
        RestMethod annotation = method.getAnnotation(RestMethod.class);
        if (annotation != null && annotation.required() != null) {
            for (String required : annotation.required()) {
                if (required == null || null != request.getParameter(required) && 0 != request.getParameter(required).trim().length()) continue;
                throw new RequiredParameterException(method.getName(), required);
            }
        }
        return annotation;
    }

    public SortedMap<String, RestMethodInfo> getMethods() {
        return RestHandler.getClassMethodNames(this.target.getClass(), this.methodNamePrefix);
    }

    public static SortedMap<String, RestMethodInfo> getClassMethodNames(Class klass, String prefix) {
        Method[] methods;
        TreeMap<String, RestMethodInfo> result = new TreeMap<String, RestMethodInfo>();
        for (Method method : methods = klass.getDeclaredMethods()) {
            Class<?>[] parameter_types = method.getParameterTypes();
            RestMethod annotation = method.getAnnotation(RestMethod.class);
            if (annotation == null || Void.TYPE != method.getReturnType() || (2 != parameter_types.length || RestRequest.class != parameter_types[0] || RestResponse.class != parameter_types[1]) && (1 != parameter_types.length || RestResponse.class != parameter_types[0])) continue;
            String methodName = method.getName();
            methodName = StringUtils.addMethodNamePrefix(methodName, prefix);
            result.put(methodName, new RestMethodInfo(annotation.required(), annotation.optional(), annotation.visibility(), annotation.description()));
        }
        return result;
    }

    protected RestResponse buildRestResponse(HttpServletResponse response, String methodName, ResponseBuilder responseBuilder) {
        RestResponse restResponse = new RestResponse(response, responseBuilder);
        this.setDefaultRootResponseName(methodName, restResponse);
        return restResponse;
    }

    private void setDefaultRootResponseName(String methodName, RestResponse restResponse) {
        restResponse.name(this.getDefaultRootResponseName(methodName));
    }

    protected String getDefaultRootResponseName(String methodName) {
        if (methodName.startsWith(GETTER_PREFIX)) {
            return StringUtils.uncapitalize(methodName.substring(GETTER_PREFIX.length()));
        }
        return methodName;
    }

    protected void outputError(HttpServletResponse response, String message) {
        response.setStatus(500);
        response.setContentType("text/plain");
        try {
            PrintWriter out = response.getWriter();
            out.print(message);
            out.close();
        }
        catch (IOException e) {
            LOG.error(message);
        }
    }

    protected void outputException(HttpServletResponse response, Throwable e) {
        response.setStatus(500);
        response.setContentType("text/plain");
        try {
            PrintWriter out = response.getWriter();
            e.printStackTrace(out);
            out.close();
        }
        catch (IOException e1) {
            LOG.error(ExceptionUtils.getExceptionStackTrace(e));
        }
    }

    private ResponseBuilder determineResponseBuilder(HttpServletRequest request) {
        ResponseBuilder responseBuilder = null;
        String formatParameter = request.getParameter(FORMAT_PARAMETER_NAME);
        if (formatParameter != null) {
            ResponseType responseType = ResponseType.valueOf(formatParameter.toUpperCase());
            if (null == responseType) {
                throw new IllegalArgumentException("Format '" + formatParameter + "' isn't supported");
            }
            responseBuilder = responseType.getResponseBuilder();
        }
        if (null == responseBuilder) {
            responseBuilder = new TextResponseBuilder();
        }
        return responseBuilder;
    }
}

