/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common.handler;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.javax.servlet.ServletException;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletRequest;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletResponse;
import org.terracotta.ehcachedx.license.LicenseResolver;
import org.terracotta.ehcachedx.monitor.util.ExceptionUtils;
import org.terracotta.ehcachedx.org.mortbay.jetty.Request;
import org.terracotta.ehcachedx.org.mortbay.jetty.handler.AbstractHandler;
import org.terracotta.license.LicenseException;

public class LicenseHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseHandler.class);
    private volatile boolean initialised = false;
    private volatile LicenseResolver resolver;
    private volatile boolean hasLicense = false;

    public void registerLicense(String license) {
        if (this.resolver != null) {
            return;
        }
        this.hasLicense = license != null;
        this.resolver = new LicenseResolver(license);
        try {
            this.resolver.resolveLicense();
        }
        catch (LicenseException e) {
            LOG.warn(e.getMessage());
            LOG.debug(ExceptionUtils.getExceptionStackTrace(e));
        }
        this.initialised = true;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        while (!this.initialised) {
            try {
                Thread.sleep(100L);
                LOG.info("License Handler not initialised. Waiting 100ms.");
            }
            catch (InterruptedException e) {
                throw new ServletException("Handler could not be initialised");
            }
        }
        if (!this.isRequestAllowed()) {
            response.setStatus(402);
            ((Request)request).setHandled(true);
        }
    }

    public boolean hasLicense() {
        return this.hasLicense;
    }

    public String getLicenseType() {
        if (null == this.resolver || null == this.resolver.getLicense()) {
            return null;
        }
        return this.resolver.getLicense().type();
    }

    public String getLicenseText() {
        if (null == this.resolver) {
            return null;
        }
        return this.resolver.getLicenseText();
    }

    private boolean isRequestAllowed() {
        return null != this.resolver && this.resolver.isMonitorSupported();
    }

    public boolean isLicensed() {
        if (null == this.resolver || null == this.resolver.getLicense()) {
            return false;
        }
        return this.resolver.getLicense().type().equals("Commercial") && !this.resolver.getLicense().isExpired();
    }
}

