/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Statistic {
    removed,
    put,
    updated,
    expired,
    evicted,
    hit,
    hitMemory,
    hitDisk,
    hitRatio(true),
    miss,
    totalCount,
    diskCount,
    memoryCount,
    memorySize;

    private static final SortedSet<String> NAMES;
    private boolean average;
    private int decimals;

    public static SortedSet<String> getNames() {
        return NAMES;
    }

    public static String[] getNamesAsArray() {
        String[] names = new String[NAMES.size()];
        int index = 0;
        for (String name : NAMES) {
            names[index] = name.toString();
            ++index;
        }
        return names;
    }

    private Statistic() {
        this(1, false);
    }

    private Statistic(int decimals) {
        this(decimals, false);
    }

    private Statistic(boolean average) {
        this(1, average);
    }

    private Statistic(int decimals, boolean average) {
        this.decimals = decimals;
        this.average = average;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean isAverage() {
        return this.average;
    }

    static {
        TreeSet<String> names = new TreeSet<String>();
        for (Statistic name : Statistic.values()) {
            names.add(name.name());
        }
        NAMES = Collections.unmodifiableSortedSet(names);
    }
}

