/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.monitor.common.Statistic;
import org.terracotta.ehcachedx.monitor.common.rest.RestMethod;
import org.terracotta.ehcachedx.monitor.common.rest.RestResponse;
import org.terracotta.ehcachedx.monitor.common.rest.Visibility;
import org.terracotta.ehcachedx.monitor.util.StringUtils;

public class GeneralService {
    public static final int DEFAULT_SAMPLING_SECONDS = 10;
    private static final Logger LOG = LoggerFactory.getLogger(GeneralService.class);
    private int samplingSeconds;
    private int samplingHistory;
    private String version;

    public GeneralService(Integer samplingHistory, Integer samplingSeconds) {
        this.parseVersion();
        this.samplingHistory = samplingHistory;
        this.samplingSeconds = samplingSeconds;
    }

    private void parseVersion() {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("/monitor.properties"));
        }
        catch (IOException e) {
            properties.put("version", "unknown");
        }
        this.version = String.valueOf(properties.get("version"));
    }

    @RestMethod(required={}, optional={}, visibility=Visibility.PUBLIC, description="The API Version. Resources can change between versions")
    public void getVersion(RestResponse response) throws IOException {
        response.value(this.version);
    }

    @RestMethod(required={}, optional={}, visibility=Visibility.PUBLIC, description="The sampling interval, i.e. the number of seconds between probe sampling.")
    public void getSamplingSeconds(RestResponse response) throws IOException {
        response.value(this.samplingSeconds);
    }

    @RestMethod(required={}, optional={}, visibility=Visibility.PUBLIC, description="The number of samples stored in the monitor.")
    public void getSamplingHistory(RestResponse response) throws IOException {
        response.value(this.samplingHistory);
    }

    @RestMethod(required={}, optional={}, visibility=Visibility.PUBLIC, description="The maximum amount of history which will be stored on the monitor. It is calculated as the sampling interval * the number of history samples.")
    public void AmountOfHistoryStoredOnMonitor(RestResponse response) {
        long historyInSeconds = this.samplingSeconds * this.samplingHistory;
        response.value(StringUtils.secondsToFormattedTime(historyInSeconds));
    }

    @RestMethod
    public void getSampledStatisticNames(RestResponse response) throws IOException {
        response.childType("name").children(Statistic.getNames());
    }
}

