/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.license;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.license.EnterpriseLicenseResolverFactory;
import org.terracotta.license.License;
import org.terracotta.license.LicenseBuilder;
import org.terracotta.license.LicenseConstants;
import org.terracotta.license.LicenseException;
import org.terracotta.license.util.Base64;
import org.terracotta.license.util.IOUtils;

public class LicenseResolver {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseResolver.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final long DEFAULT_TEMP_LICENSE_LIFETIME = 259200000L;
    public static final String RESOURCE_PREFIX = "resource:";
    public static final String BASE64_PREFIX = "base64:";
    private final String licenseDeclaration;
    private License license;

    public LicenseResolver(String licenseDeclaration) {
        this.licenseDeclaration = licenseDeclaration;
    }

    public License getLicense() {
        return this.license;
    }

    public String getLicenseText() {
        return this.license.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveLicense() throws LicenseException {
        block9: {
            try {
                if (this.licenseDeclaration == null) break block9;
                InputStream licenseStream = null;
                licenseStream = this.licenseDeclaration.startsWith(RESOURCE_PREFIX) ? this.getLicenseStreamFromResource(this.licenseDeclaration.substring(RESOURCE_PREFIX.length())) : (this.licenseDeclaration.startsWith(BASE64_PREFIX) ? LicenseResolver.getLicenseStreamFromBase64(this.licenseDeclaration.substring(BASE64_PREFIX.length())) : LicenseResolver.getLicenseStreamFromPath(this.licenseDeclaration));
                if (licenseStream == null) {
                    throw new AssertionError((Object)"licenseStream is null");
                }
                try {
                    this.license = new EnterpriseLicenseResolverFactory().resolveLicense(licenseStream);
                    if (this.license.isExpired()) {
                        LOG.error("Your license key has expired on " + this.license.expirationDate() + ". Please contact sales@terracottatech.com for a new license key.");
                    }
                }
                finally {
                    IOUtils.closeQuietly(licenseStream);
                }
            }
            finally {
                if (null == this.license) {
                    LOG.warn("No  license key found. This monitoring probe software is not licensed for production usage, and is only licensed for development usage. See LICENSE.txt for details. A temporary key will be generated for development usage. When the temporary key expires, the ing probe capability will be suspended but your ability to continue to use Ehcache will not be affected. Please contact sales@terracottatech.com to request a license.");
                    this.license = LicenseResolver.generateDevOnlyLicense();
                }
                this.logLicense();
            }
        }
    }

    private void logLicense() {
        String licenseInfo = LINE_SEPARATOR + "---------------  license key ---------------" + LINE_SEPARATOR + this.license.toString() + "-----------------------------------------------";
        LOG.info(licenseInfo);
    }

    public boolean isMonitorSupported() {
        return this.isCapabilitySupported("ehcache monitor");
    }

    public boolean isCapabilitySupported(String capability) {
        if (this.license.isExpired()) {
            if ("DevOnly".equals(this.license.type())) {
                LOG.error("Your license key has expired. The ing probe capability will be suspended until restarted. Ehcache will not be affected. For a license for use in production please contact sales@terracottatech.com.");
            } else {
                LOG.error("Your license key has expired. The ing probe capability will be suspended. Ehcache will not be affected. For a license for use in production please contact sales@terracottatech.com.");
            }
            return false;
        }
        if (!this.license.capabilities().contains(capability)) {
            LOG.error("Your license key doesn't allow feature '" + capability + "'. Please contact sales@terracottatech.com for details.");
            return false;
        }
        return true;
    }

    private static License generateDevOnlyLicense() {
        Date expirationDate = new Date(System.currentTimeMillis() + 259200000L);
        LicenseBuilder builder = new LicenseBuilder();
        builder.setProduct("Ehcache");
        builder.setEdition("DX");
        List<String> capabilities = Arrays.asList("ehcache monitor");
        builder.setCapabilities(capabilities);
        builder.setLicensee("DevOnly");
        builder.setLicenseNumber("0000");
        builder.setLicenseType("DevOnly");
        builder.setExpirationDate(LicenseConstants.dateFormatter().format(expirationDate));
        License devLicense = builder.createUnsignedLicense();
        return devLicense;
    }

    private InputStream getLicenseStreamFromResource(String resource) throws LicenseException {
        if (resource == null || resource.trim().length() == 0) {
            throw new LicenseException("Resource path to license key empty or null");
        }
        String resourceFromRoot = resource.startsWith("/") ? resource : "/" + resource;
        InputStream in = LicenseResolver.class.getResourceAsStream(resourceFromRoot);
        if (in == null) {
            throw new LicenseException("No license key found at resource path: " + resource);
        }
        LOG.info("License file found in resource: " + resource);
        return in;
    }

    private static InputStream getLicenseStreamFromBase64(String content) {
        return new ByteArrayInputStream(Base64.decode(content));
    }

    private static InputStream getLicenseStreamFromPath(String path) throws LicenseException {
        if (path == null) {
            throw new LicenseException("Path to license key is null");
        }
        try {
            FileInputStream in = new FileInputStream(path);
            LOG.info("License file found at: " + path);
            return in;
        }
        catch (FileNotFoundException e) {
            throw new LicenseException("Can't find license key at path: " + path);
        }
    }
}

