/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.com.javabi.sizeof.definition;

import java.io.PrintStream;
import java.util.Set;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinitionMap;
import org.terracotta.ehcachedx.com.javabi.sizeof.MemoryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectArrayDefinition
extends ClassDefinition<Object[]> {
    @Override
    public long sizeOf(Object[] array) {
        return ObjectArrayDefinition.sizeOfIntArray(array.length);
    }

    @Override
    public final boolean hasElements(Object[] array) {
        return array.length > 0;
    }

    @Override
    public long sizeOfElements(Object[] array, ClassDefinitionMap definitionMap, Set<Object> instanceSet, long size) throws IllegalAccessException {
        for (Object element : array) {
            if (element == null) continue;
            size += MemoryUtil.sizeOf(element, definitionMap, instanceSet);
        }
        return size;
    }

    @Override
    public long sizeOfDebug(Object[] array, ClassDefinitionMap definitionMap, Set<Object> instanceSet, PrintStream stream) throws IllegalAccessException {
        long arraySize = ObjectArrayDefinition.sizeOfIntArray(array.length);
        stream.println("new Object[" + array.length + "] " + arraySize + " bytes");
        for (int index = 0; index < array.length; ++index) {
            Object element = array[index];
            if (element == null) continue;
            long elementSize = MemoryUtil.sizeOfDebug(element, definitionMap, instanceSet, stream);
            stream.println("Object[" + index + "] " + elementSize + " bytes");
            arraySize += elementSize;
        }
        return arraySize;
    }
}

