/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.com.javabi.sizeof.definition;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinitionMap;
import org.terracotta.ehcachedx.com.javabi.sizeof.MemoryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMapDefinition
extends ClassDefinition<LinkedHashMap> {
    private final Field tableField = HashMap.class.getDeclaredField("table");
    private final Class<?> entryClass;
    private final Field keyField;
    private final Field valueField;
    private final Field nextField;

    public LinkedHashMapDefinition() throws ClassNotFoundException, NoSuchFieldException {
        this.tableField.setAccessible(true);
        this.entryClass = Class.forName("java.util.HashMap$Entry");
        this.keyField = this.entryClass.getDeclaredField("key");
        this.keyField.setAccessible(true);
        this.valueField = this.entryClass.getDeclaredField("value");
        this.valueField.setAccessible(true);
        this.nextField = this.entryClass.getDeclaredField("next");
        this.nextField.setAccessible(true);
    }

    @Override
    public long sizeOf(LinkedHashMap map) {
        return 80L;
    }

    @Override
    public final boolean hasElements(LinkedHashMap map) {
        return true;
    }

    @Override
    public long sizeOfElements(LinkedHashMap map, ClassDefinitionMap definitionMap, Set<Object> instanceSet, long size) throws IllegalAccessException {
        int mapSize = map.size();
        Object[] table = (Object[])this.tableField.get(map);
        instanceSet.add(table);
        size += LinkedHashMapDefinition.sizeOfIntArray(table.length);
        if (mapSize > 0) {
            block0: for (Object entry : table) {
                while (entry != null) {
                    instanceSet.add(entry);
                    size += 24L;
                    Object key = this.keyField.get(entry);
                    Object value = this.valueField.get(entry);
                    if (key != null) {
                        size += MemoryUtil.sizeOf(key, definitionMap, instanceSet);
                    }
                    if (key != value && value != null) {
                        size += MemoryUtil.sizeOf(value, definitionMap, instanceSet);
                    }
                    if (--mapSize == 0) continue block0;
                    entry = this.nextField.get(entry);
                }
            }
        }
        return size;
    }
}

