package org.terracotta.ehcachedx.monitor.probe.counter.sampled.memory;

import java.util.IdentityHashMap;
import java.util.Map;

public class MemoryConfig {

    public int INSTANCE_OVERHEAD;
    public boolean COUNT_INSTANCE_OVERHEAD;

    private boolean COUNT_REFS;
    private int REFERENCE_SIZE;

    private final Map primitiveSizes = new IdentityHashMap<Class, Integer>() {
        {
            put(boolean.class, new Integer(1));
            put(Boolean.class, new Integer(1));
            put(char.class, new Integer(2));
            put(Character.class, new Integer(2));
            put(byte.class, new Integer(1));
            put(Byte.class, new Integer(1));
            put(short.class, new Integer(2));
            put(Short.class, new Integer(2));
            put(int.class, new Integer(4));
            put(Integer.class, new Integer(4));
            put(float.class, new Integer(4));
            put(Float.class, new Integer(4));
            put(long.class, new Integer(8));
            put(Long.class, new Integer(8));
            put(double.class, new Integer(8));
            put(Double.class, new Integer(8));
        }


    };


    public int getInstanceOverhead() {
        return COUNT_INSTANCE_OVERHEAD ? INSTANCE_OVERHEAD: 0;
    }

    public Integer getPrimitiveSize(Class clazz) {
        return (Integer) primitiveSizes.get(clazz);
    }

    public int getRefSize() {
            if (COUNT_REFS) {
                return REFERENCE_SIZE;
            }
        return 0;
    }

        //todo: can assume 64-bit for now
    public MemoryConfig() {
        this.REFERENCE_SIZE = 8;
        this.COUNT_REFS = true;
        this.INSTANCE_OVERHEAD = 40;
    }

    public MemoryConfig(boolean countRefs, boolean countInstanceOverhead) {
        this.COUNT_REFS = countRefs;
        this.COUNT_INSTANCE_OVERHEAD = countInstanceOverhead;
    }
}
