package org.terracotta.ehcachedx.monitor.probe.counter.sampled.memory;

import net.sf.ehcache.Ehcache;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

import java.util.concurrent.Callable;

/**
 * CacheMemorySizeCalculator
 * Takes numerous stored Samples and gets the 97th percentile to get something
 * closer to a real figure.
 * Particularly useful for caches with large variances.
 */
public class CacheMemorySizeCalculator implements Callable<Long> {
    private Ehcache cache;
    private DescriptiveStatistics objectSamples;

    public CacheMemorySizeCalculator(Ehcache cache, DescriptiveStatistics objectStats) {
        this.cache = cache;
        this.objectSamples = objectStats;
    }

    protected long getAdjustedSample() {
        return java.lang.Math.round(objectSamples.getPercentile(97));
    }

    public Long call() throws Exception {
        return cache.getMemoryStoreSize() * getAdjustedSample();
    }

}
