/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package org.terracotta.ehcachedx.monitor.probe.counter.sampled;

import java.io.Serializable;

/**
 * A counter value at a particular time instance
 */
public class TimeStampedCounterValue implements Serializable {
    private final long timeStamp;
    private final long counterValue;

    public TimeStampedCounterValue(long timeStamp, long value) {
        this.timeStamp = timeStamp;
        this.counterValue = value;
    }

    public long getCounterValue() {
        return this.counterValue;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        return "value: " + this.counterValue + ", time stamp: " + this.timeStamp;
    }

}
