/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package org.terracotta.ehcachedx.monitor.probe.counter;

import org.terracotta.ehcachedx.monitor.probe.counter.sampled.SampledCounterImpl;

import java.util.Timer;

public class CounterManagerImpl implements CounterManager {
    private final Timer timer = new Timer("CounterManagerImpl Timer", true);
    private boolean shutdown = false;

    public synchronized void shutdown() {
        if (shutdown) {
            return;
        }
        try {
            timer.cancel();
        } finally {
            shutdown = true;
        }
    }

    public synchronized Counter createCounter(CounterConfig config) {
        if (shutdown) {
            throw new IllegalStateException("counter manager is shut down");
        }
        if (config == null) {
            throw new NullPointerException("config cannot be null");
        }

        Counter counter = config.createCounter();
        if (counter instanceof SampledCounterImpl) {
            SampledCounterImpl sampledCounter = (SampledCounterImpl) counter;
            timer.schedule(sampledCounter.getTimerTask(), sampledCounter.getIntervalMillis(), sampledCounter
                    .getIntervalMillis());
        }
        return counter;
    }
}
