package org.terracotta.ehcachedx.monitor.probe;

/**
 * Used only by SampledCacheStatistics
 */
public class SampleRange {
    private int firstSample;
    private int lastSample;
    private int numSamples;

    public SampleRange(long fromTimeSeconds, int timeInterval, int sampleRate, int offset, int maxSample) {
        // TODO Division may not always be exact. What happens then?
        numSamples = timeInterval / sampleRate + 1;

        if (fromTimeSeconds == 0) {
            lastSample = maxSample;
            firstSample = lastSample - numSamples + 1;
        } else {
            // TODO Fix int/long casting.
            long currentTimeSeconds = System.currentTimeMillis() / 1000;
            int samplesAgo = (int) ((currentTimeSeconds - fromTimeSeconds) / sampleRate);
            firstSample = maxSample - samplesAgo + 1;
            lastSample = firstSample + numSamples - 1;
        }

        if (offset == 1) {
            firstSample += numSamples - 1;
            lastSample += numSamples - 1;
        } else if (offset == -1) {
            firstSample -= numSamples - 1;
            lastSample -= numSamples - 1;
        }

        if (lastSample > maxSample) {
            lastSample = maxSample;
            firstSample = lastSample - numSamples + 1;
        }
        if (firstSample < 0) {
            firstSample = 0;
            lastSample = firstSample + numSamples - 1;
            if (lastSample > maxSample) {
                lastSample = maxSample;
            }
        }
        numSamples = lastSample - firstSample + 1;
    }

    public int getFirstSample() {
        return firstSample;
    }

    public int getLastSample() {
        return lastSample;
    }

    public int getNumSamples() {
        return numSamples;
    }
}
