/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package org.terracotta.ehcachedx.monitor.probe;

import org.terracotta.ehcachedx.monitor.common.rest.RestMethod;
import org.terracotta.ehcachedx.monitor.common.rest.RestRequest;
import org.terracotta.ehcachedx.monitor.common.rest.RestResponse;
import org.terracotta.ehcachedx.monitor.common.rest.Visibility;

import java.io.IOException;

import static org.terracotta.ehcachedx.monitor.common.rest.RestConstants.PARAM_CHALLENGE;

/**
 * Used by the Probe only
 *
 * This is used by the Monitor to ping the probe and check that it is still there.
 */
public class ProbeService {

    @RestMethod(visibility = Visibility.PRIVATE, required = {PARAM_CHALLENGE})
    public void checkProbe(RestRequest request, RestResponse response) throws IOException {
        response.value(request.getParameter(PARAM_CHALLENGE));
    }
}