/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.org.apache.commons.math.stat.descriptive;

import java.io.Serializable;
import java.util.Arrays;
import org.terracotta.org.apache.commons.math.DimensionMismatchException;
import org.terracotta.org.apache.commons.math.MathRuntimeException;
import org.terracotta.org.apache.commons.math.linear.RealMatrix;
import org.terracotta.org.apache.commons.math.stat.descriptive.StatisticalMultivariateSummary;
import org.terracotta.org.apache.commons.math.stat.descriptive.StorelessUnivariateStatistic;
import org.terracotta.org.apache.commons.math.stat.descriptive.moment.GeometricMean;
import org.terracotta.org.apache.commons.math.stat.descriptive.moment.Mean;
import org.terracotta.org.apache.commons.math.stat.descriptive.moment.VectorialCovariance;
import org.terracotta.org.apache.commons.math.stat.descriptive.rank.Max;
import org.terracotta.org.apache.commons.math.stat.descriptive.rank.Min;
import org.terracotta.org.apache.commons.math.stat.descriptive.summary.Sum;
import org.terracotta.org.apache.commons.math.stat.descriptive.summary.SumOfLogs;
import org.terracotta.org.apache.commons.math.stat.descriptive.summary.SumOfSquares;
import org.terracotta.org.apache.commons.math.util.MathUtils;

public class MultivariateSummaryStatistics
implements StatisticalMultivariateSummary,
Serializable {
    private static final long serialVersionUID = 2271900808994826718L;
    private int k;
    private long n = 0L;
    private StorelessUnivariateStatistic[] sumImpl;
    private StorelessUnivariateStatistic[] sumSqImpl;
    private StorelessUnivariateStatistic[] minImpl;
    private StorelessUnivariateStatistic[] maxImpl;
    private StorelessUnivariateStatistic[] sumLogImpl;
    private StorelessUnivariateStatistic[] geoMeanImpl;
    private StorelessUnivariateStatistic[] meanImpl;
    private VectorialCovariance covarianceImpl;

    public MultivariateSummaryStatistics(int k, boolean isCovarianceBiasCorrected) {
        this.k = k;
        this.sumImpl = new StorelessUnivariateStatistic[k];
        this.sumSqImpl = new StorelessUnivariateStatistic[k];
        this.minImpl = new StorelessUnivariateStatistic[k];
        this.maxImpl = new StorelessUnivariateStatistic[k];
        this.sumLogImpl = new StorelessUnivariateStatistic[k];
        this.geoMeanImpl = new StorelessUnivariateStatistic[k];
        this.meanImpl = new StorelessUnivariateStatistic[k];
        for (int i = 0; i < k; ++i) {
            this.sumImpl[i] = new Sum();
            this.sumSqImpl[i] = new SumOfSquares();
            this.minImpl[i] = new Min();
            this.maxImpl[i] = new Max();
            this.sumLogImpl[i] = new SumOfLogs();
            this.geoMeanImpl[i] = new GeometricMean();
            this.meanImpl[i] = new Mean();
        }
        this.covarianceImpl = new VectorialCovariance(k, isCovarianceBiasCorrected);
    }

    public void addValue(double[] value) throws DimensionMismatchException {
        this.checkDimension(value.length);
        for (int i = 0; i < this.k; ++i) {
            double v = value[i];
            this.sumImpl[i].increment(v);
            this.sumSqImpl[i].increment(v);
            this.minImpl[i].increment(v);
            this.maxImpl[i].increment(v);
            this.sumLogImpl[i].increment(v);
            this.geoMeanImpl[i].increment(v);
            this.meanImpl[i].increment(v);
        }
        this.covarianceImpl.increment(value);
        ++this.n;
    }

    public int getDimension() {
        return this.k;
    }

    public long getN() {
        return this.n;
    }

    private double[] getResults(StorelessUnivariateStatistic[] stats) {
        double[] results = new double[stats.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = stats[i].getResult();
        }
        return results;
    }

    public double[] getSum() {
        return this.getResults(this.sumImpl);
    }

    public double[] getSumSq() {
        return this.getResults(this.sumSqImpl);
    }

    public double[] getSumLog() {
        return this.getResults(this.sumLogImpl);
    }

    public double[] getMean() {
        return this.getResults(this.meanImpl);
    }

    public double[] getStandardDeviation() {
        double[] stdDev = new double[this.k];
        if (this.getN() < 1L) {
            Arrays.fill(stdDev, Double.NaN);
        } else if (this.getN() < 2L) {
            Arrays.fill(stdDev, 0.0);
        } else {
            RealMatrix matrix = this.covarianceImpl.getResult();
            for (int i = 0; i < this.k; ++i) {
                stdDev[i] = Math.sqrt(matrix.getEntry(i, i));
            }
        }
        return stdDev;
    }

    public RealMatrix getCovariance() {
        return this.covarianceImpl.getResult();
    }

    public double[] getMax() {
        return this.getResults(this.maxImpl);
    }

    public double[] getMin() {
        return this.getResults(this.minImpl);
    }

    public double[] getGeometricMean() {
        return this.getResults(this.geoMeanImpl);
    }

    public String toString() {
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("MultivariateSummaryStatistics:\n");
        outBuffer.append("n: " + this.getN() + "\n");
        this.append(outBuffer, this.getMin(), "min: ", ", ", "\n");
        this.append(outBuffer, this.getMax(), "max: ", ", ", "\n");
        this.append(outBuffer, this.getMean(), "mean: ", ", ", "\n");
        this.append(outBuffer, this.getGeometricMean(), "geometric mean: ", ", ", "\n");
        this.append(outBuffer, this.getSumSq(), "sum of squares: ", ", ", "\n");
        this.append(outBuffer, this.getSumLog(), "sum of logarithms: ", ", ", "\n");
        this.append(outBuffer, this.getStandardDeviation(), "standard deviation: ", ", ", "\n");
        outBuffer.append("covariance: " + this.getCovariance().toString() + "\n");
        return outBuffer.toString();
    }

    private void append(StringBuffer buffer, double[] data, String prefix, String separator, String suffix) {
        buffer.append(prefix);
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(data[i]);
        }
        buffer.append(suffix);
    }

    public void clear() {
        this.n = 0L;
        for (int i = 0; i < this.k; ++i) {
            this.minImpl[i].clear();
            this.maxImpl[i].clear();
            this.sumImpl[i].clear();
            this.sumLogImpl[i].clear();
            this.sumSqImpl[i].clear();
            this.geoMeanImpl[i].clear();
            this.meanImpl[i].clear();
        }
        this.covarianceImpl.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultivariateSummaryStatistics)) {
            return false;
        }
        MultivariateSummaryStatistics stat = (MultivariateSummaryStatistics)object;
        return MathUtils.equals((double[])stat.getGeometricMean(), (double[])this.getGeometricMean()) && MathUtils.equals((double[])stat.getMax(), (double[])this.getMax()) && MathUtils.equals((double[])stat.getMean(), (double[])this.getMean()) && MathUtils.equals((double[])stat.getMin(), (double[])this.getMin()) && MathUtils.equals((double)stat.getN(), (double)this.getN()) && MathUtils.equals((double[])stat.getSum(), (double[])this.getSum()) && MathUtils.equals((double[])stat.getSumSq(), (double[])this.getSumSq()) && MathUtils.equals((double[])stat.getSumLog(), (double[])this.getSumLog()) && stat.getCovariance().equals(this.getCovariance());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash((double[])this.getGeometricMean());
        result = result * 31 + MathUtils.hash((double[])this.getGeometricMean());
        result = result * 31 + MathUtils.hash((double[])this.getMax());
        result = result * 31 + MathUtils.hash((double[])this.getMean());
        result = result * 31 + MathUtils.hash((double[])this.getMin());
        result = result * 31 + MathUtils.hash((double)this.getN());
        result = result * 31 + MathUtils.hash((double[])this.getSum());
        result = result * 31 + MathUtils.hash((double[])this.getSumSq());
        result = result * 31 + MathUtils.hash((double[])this.getSumLog());
        result = result * 31 + this.getCovariance().hashCode();
        return result;
    }

    private void setImpl(StorelessUnivariateStatistic[] newImpl, StorelessUnivariateStatistic[] oldImpl) throws DimensionMismatchException, IllegalStateException {
        this.checkEmpty();
        this.checkDimension(newImpl.length);
        System.arraycopy(newImpl, 0, oldImpl, 0, newImpl.length);
    }

    public StorelessUnivariateStatistic[] getSumImpl() {
        return (StorelessUnivariateStatistic[])this.sumImpl.clone();
    }

    public void setSumImpl(StorelessUnivariateStatistic[] sumImpl) throws DimensionMismatchException {
        this.setImpl(sumImpl, this.sumImpl);
    }

    public StorelessUnivariateStatistic[] getSumsqImpl() {
        return (StorelessUnivariateStatistic[])this.sumSqImpl.clone();
    }

    public void setSumsqImpl(StorelessUnivariateStatistic[] sumsqImpl) throws DimensionMismatchException {
        this.setImpl(sumsqImpl, this.sumSqImpl);
    }

    public StorelessUnivariateStatistic[] getMinImpl() {
        return (StorelessUnivariateStatistic[])this.minImpl.clone();
    }

    public void setMinImpl(StorelessUnivariateStatistic[] minImpl) throws DimensionMismatchException {
        this.setImpl(minImpl, this.minImpl);
    }

    public StorelessUnivariateStatistic[] getMaxImpl() {
        return (StorelessUnivariateStatistic[])this.maxImpl.clone();
    }

    public void setMaxImpl(StorelessUnivariateStatistic[] maxImpl) throws DimensionMismatchException {
        this.setImpl(maxImpl, this.maxImpl);
    }

    public StorelessUnivariateStatistic[] getSumLogImpl() {
        return (StorelessUnivariateStatistic[])this.sumLogImpl.clone();
    }

    public void setSumLogImpl(StorelessUnivariateStatistic[] sumLogImpl) throws DimensionMismatchException {
        this.setImpl(sumLogImpl, this.sumLogImpl);
    }

    public StorelessUnivariateStatistic[] getGeoMeanImpl() {
        return (StorelessUnivariateStatistic[])this.geoMeanImpl.clone();
    }

    public void setGeoMeanImpl(StorelessUnivariateStatistic[] geoMeanImpl) throws DimensionMismatchException {
        this.setImpl(geoMeanImpl, this.geoMeanImpl);
    }

    public StorelessUnivariateStatistic[] getMeanImpl() {
        return (StorelessUnivariateStatistic[])this.meanImpl.clone();
    }

    public void setMeanImpl(StorelessUnivariateStatistic[] meanImpl) throws DimensionMismatchException {
        this.setImpl(meanImpl, this.meanImpl);
    }

    private void checkEmpty() {
        if (this.n > 0L) {
            throw MathRuntimeException.createIllegalStateException((String)"{0} values have been added before statistic is configured", (Object[])new Object[]{this.n});
        }
    }

    private void checkDimension(int dimension) throws DimensionMismatchException {
        if (dimension != this.k) {
            throw new DimensionMismatchException(dimension, this.k);
        }
    }
}

