/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import org.terracotta.ehcachedx.javax.servlet.ServletException;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletRequest;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletResponse;
import org.terracotta.ehcachedx.org.mortbay.jetty.Connector;
import org.terracotta.ehcachedx.org.mortbay.jetty.HttpConnection;
import org.terracotta.ehcachedx.org.mortbay.jetty.Request;
import org.terracotta.ehcachedx.org.mortbay.jetty.Response;
import org.terracotta.ehcachedx.org.mortbay.jetty.handler.HandlerWrapper;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.Authenticator;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.BasicAuthenticator;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.ClientCertAuthenticator;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.Constraint;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.ConstraintMapping;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.DigestAuthenticator;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.FormAuthenticator;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.UserRealm;
import org.terracotta.ehcachedx.org.mortbay.jetty.servlet.PathMap;
import org.terracotta.ehcachedx.org.mortbay.log.Log;
import org.terracotta.ehcachedx.org.mortbay.util.LazyList;
import org.terracotta.ehcachedx.org.mortbay.util.StringUtil;

public class SecurityHandler
extends HandlerWrapper {
    private String _authMethod = "BASIC";
    private UserRealm _userRealm;
    private ConstraintMapping[] _constraintMappings;
    private final PathMap _constraintMap = new PathMap();
    private Authenticator _authenticator;
    private final NotChecked _notChecked = new NotChecked();
    private boolean _checkWelcomeFiles = false;
    public static Principal __NO_USER = new Principal(){

        public String getName() {
            return null;
        }

        public String toString() {
            return "No User";
        }
    };
    public static Principal __NOBODY = new Principal(){

        public String getName() {
            return "Nobody";
        }

        public String toString() {
            return this.getName();
        }
    };

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public UserRealm getUserRealm() {
        return this._userRealm;
    }

    public void setUserRealm(UserRealm userRealm) {
        this._userRealm = userRealm;
    }

    public ConstraintMapping[] getConstraintMappings() {
        return this._constraintMappings;
    }

    public void setConstraintMappings(ConstraintMapping[] constraintMappings) {
        this._constraintMappings = constraintMappings;
        if (this._constraintMappings != null) {
            this._constraintMappings = constraintMappings;
            this._constraintMap.clear();
            for (int i = 0; i < this._constraintMappings.length; ++i) {
                Object mappings = this._constraintMap.get(this._constraintMappings[i].getPathSpec());
                mappings = LazyList.add(mappings, this._constraintMappings[i]);
                this._constraintMap.put(this._constraintMappings[i].getPathSpec(), mappings);
            }
        }
    }

    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String method) {
        if (this.isStarted() && this._authMethod != null && !this._authMethod.equals(method)) {
            throw new IllegalStateException("Handler started");
        }
        this._authMethod = method;
    }

    public boolean hasConstraints() {
        return this._constraintMappings != null && this._constraintMappings.length > 0;
    }

    public boolean isCheckWelcomeFiles() {
        return this._checkWelcomeFiles;
    }

    public void setCheckWelcomeFiles(boolean authenticateWelcomeFiles) {
        this._checkWelcomeFiles = authenticateWelcomeFiles;
    }

    public void doStart() throws Exception {
        if (this._authenticator == null) {
            if ("BASIC".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new DigestAuthenticator();
            } else if ("CLIENT_CERT".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new ClientCertAuthenticator();
            } else if ("FORM".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new FormAuthenticator();
            } else {
                Log.warn("Unknown Authentication method:" + this._authMethod);
            }
        }
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        UserRealm old_realm;
        Request base_request;
        block14: {
            block13: {
                block12: {
                    base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
                    Response base_response = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
                    old_realm = base_request.getUserRealm();
                    try {
                        base_request.setUserRealm(this.getUserRealm());
                        if (dispatch == 1 && !this.checkSecurityConstraints(target, base_request, base_response)) {
                            base_request.setHandled(true);
                            Object var9_8 = null;
                            if (this._userRealm != null && dispatch == 1) {
                                this._userRealm.disassociate(base_request.getUserPrincipal());
                            }
                            base_request.setUserRealm(old_realm);
                            return;
                        }
                        if (dispatch == 2 && this._checkWelcomeFiles && request.getAttribute("org.mortbay.jetty.welcome") != null) {
                            request.removeAttribute("org.mortbay.jetty.welcome");
                            if (!this.checkSecurityConstraints(target, base_request, base_response)) {
                                base_request.setHandled(true);
                                break block12;
                            }
                        }
                        if (this._authenticator instanceof FormAuthenticator && target.endsWith("/j_security_check")) {
                            this._authenticator.authenticate(this.getUserRealm(), target, base_request, base_response);
                            base_request.setHandled(true);
                            break block13;
                        }
                        if (this.getHandler() != null) {
                            this.getHandler().handle(target, request, response, dispatch);
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (this._userRealm != null && dispatch == 1) {
                            this._userRealm.disassociate(base_request.getUserPrincipal());
                        }
                        base_request.setUserRealm(old_realm);
                        throw throwable;
                    }
                }
                Object var9_9 = null;
                if (this._userRealm != null && dispatch == 1) {
                    this._userRealm.disassociate(base_request.getUserPrincipal());
                }
                base_request.setUserRealm(old_realm);
                return;
            }
            Object var9_10 = null;
            if (this._userRealm != null && dispatch == 1) {
                this._userRealm.disassociate(base_request.getUserPrincipal());
            }
            base_request.setUserRealm(old_realm);
            return;
        }
        Object var9_11 = null;
        if (this._userRealm != null && dispatch == 1) {
            this._userRealm.disassociate(base_request.getUserPrincipal());
        }
        base_request.setUserRealm(old_realm);
    }

    public boolean checkSecurityConstraints(String pathInContext, Request request, Response response) throws IOException {
        Object mapping_entries = this._constraintMap.getLazyMatches(pathInContext);
        String pattern = null;
        Object constraints = null;
        if (mapping_entries != null) {
            block0: for (int m = 0; m < LazyList.size(mapping_entries); ++m) {
                Map.Entry entry = (Map.Entry)LazyList.get(mapping_entries, m);
                Object mappings = entry.getValue();
                String path_spec = (String)entry.getKey();
                for (int c = 0; c < LazyList.size(mappings); ++c) {
                    ConstraintMapping mapping = (ConstraintMapping)LazyList.get(mappings, c);
                    if (mapping.getMethod() != null && !mapping.getMethod().equalsIgnoreCase(request.getMethod())) continue;
                    if (pattern != null && !pattern.equals(path_spec)) break block0;
                    pattern = path_spec;
                    constraints = LazyList.add(constraints, mapping.getConstraint());
                }
            }
            return this.check(constraints, this._authenticator, this._userRealm, pathInContext, request, response);
        }
        request.setUserPrincipal(this._notChecked);
        return true;
    }

    private boolean check(Object constraints, Authenticator authenticator, UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        int dataConstraint = 0;
        Object roles = null;
        boolean unauthenticated = false;
        boolean forbidden = false;
        for (int c = 0; c < LazyList.size(constraints); ++c) {
            Constraint sc = (Constraint)LazyList.get(constraints, c);
            if (dataConstraint > -1 && sc.hasDataConstraint()) {
                if (sc.getDataConstraint() > dataConstraint) {
                    dataConstraint = sc.getDataConstraint();
                }
            } else {
                dataConstraint = -1;
            }
            if (unauthenticated || forbidden) continue;
            if (sc.getAuthenticate()) {
                if (sc.isAnyRole()) {
                    roles = "*";
                    continue;
                }
                String[] scr = sc.getRoles();
                if (scr == null || scr.length == 0) {
                    forbidden = true;
                    break;
                }
                if (roles == "*") continue;
                int r = scr.length;
                while (r-- > 0) {
                    roles = LazyList.add(roles, scr[r]);
                }
                continue;
            }
            unauthenticated = true;
        }
        if (!(!forbidden || authenticator instanceof FormAuthenticator && ((FormAuthenticator)authenticator).isLoginOrErrorPage(pathInContext))) {
            response.sendError(403);
            return false;
        }
        if (dataConstraint > 0) {
            HttpConnection connection = HttpConnection.getCurrentConnection();
            Connector connector = connection.getConnector();
            switch (dataConstraint) {
                case 1: {
                    String url;
                    if (connector.isIntegral(request)) break;
                    if (connector.getConfidentialPort() > 0) {
                        url = connector.getIntegralScheme() + "://" + request.getServerName() + ":" + connector.getIntegralPort() + request.getRequestURI();
                        if (request.getQueryString() != null) {
                            url = url + "?" + request.getQueryString();
                        }
                        response.setContentLength(0);
                        response.sendRedirect(response.encodeRedirectURL(url));
                    } else {
                        response.sendError(403, null);
                    }
                    return false;
                }
                case 2: {
                    String url;
                    if (connector.isConfidential(request)) break;
                    if (connector.getConfidentialPort() > 0) {
                        url = connector.getConfidentialScheme() + "://" + request.getServerName() + ":" + connector.getConfidentialPort() + request.getRequestURI();
                        if (request.getQueryString() != null) {
                            url = url + "?" + request.getQueryString();
                        }
                        response.setContentLength(0);
                        response.sendRedirect(response.encodeRedirectURL(url));
                    } else {
                        response.sendError(403, null);
                    }
                    return false;
                }
                default: {
                    response.sendError(403, null);
                    return false;
                }
            }
        }
        if (!unauthenticated && roles != null) {
            if (realm == null) {
                Log.warn("Request " + request.getRequestURI() + " failed - no realm");
                response.sendError(500, "No realm");
                return false;
            }
            Principal user = null;
            if (request.getAuthType() != null && request.getRemoteUser() != null) {
                user = request.getUserPrincipal();
                if (user == null) {
                    user = realm.authenticate(request.getRemoteUser(), null, request);
                }
                if (user == null && authenticator != null) {
                    user = authenticator.authenticate(realm, pathInContext, request, response);
                }
            } else if (authenticator != null) {
                user = authenticator.authenticate(realm, pathInContext, request, response);
            } else {
                Log.warn("Mis-configured Authenticator for " + request.getRequestURI());
                response.sendError(500, "Configuration error");
            }
            if (user == null) {
                return false;
            }
            if (user == __NOBODY) {
                return true;
            }
            if (roles != "*") {
                boolean inRole = false;
                int r = LazyList.size(roles);
                while (r-- > 0) {
                    if (!realm.isUserInRole(user, (String)LazyList.get(roles, r))) continue;
                    inRole = true;
                    break;
                }
                if (!inRole) {
                    Log.warn("AUTH FAILURE: incorrect role for " + StringUtil.printable(user.getName()));
                    response.sendError(403, "User not in required role");
                    return false;
                }
            }
        } else {
            request.setUserPrincipal(this._notChecked);
        }
        return true;
    }

    public class NotChecked
    implements Principal {
        public String getName() {
            return null;
        }

        public String toString() {
            return "NOT CHECKED";
        }

        public SecurityHandler getSecurityHandler() {
            return SecurityHandler.this;
        }
    }
}

