/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe.counter.sampled;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.PullSampledCounterConfig;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.SampledCounterImpl;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.TimeStampedCounterValue;

public class PullSampledCounterImpl
extends SampledCounterImpl {
    private static final Logger LOG = LoggerFactory.getLogger(PullSampledCounterImpl.class);
    private final boolean calculateDifference;
    private final Callable<Long> callable;
    private volatile long previous = 0L;

    public PullSampledCounterImpl(PullSampledCounterConfig config) {
        super(config);
        this.calculateDifference = config.getCalculateDifference();
        this.callable = config.getCallable();
    }

    public synchronized void setValue(long newValue) {
        this.previous = this.value.get();
        this.value.set(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void recordSample() {
        TimeStampedCounterValue timedSample;
        if (this.callable != null) {
            try {
                Long result = this.callable.call();
                if (null == result) {
                    this.setValue(0L);
                } else {
                    this.setValue(result);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
        long now = System.currentTimeMillis();
        if (this.calculateDifference) {
            PullSampledCounterImpl pullSampledCounterImpl = this;
            synchronized (pullSampledCounterImpl) {
                timedSample = new TimeStampedCounterValue(now, this.value.get() - this.previous);
            }
        } else {
            timedSample = new TimeStampedCounterValue(now, this.value.get());
        }
        this.history.push(timedSample);
    }
}

