/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheConfig {
    private static final SortedSet<String> NAMES;

    public static Object getConfigValue(String name, Ehcache cache) {
        Object result;
        try {
            Config config = Config.valueOf(name);
            result = config.getConfigValue(cache);
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        return result;
    }

    public static SortedSet<String> getNames() {
        return NAMES;
    }

    static {
        TreeSet<String> names = new TreeSet<String>();
        for (Config config : Config.values()) {
            names.add(config.name());
        }
        NAMES = Collections.unmodifiableSortedSet(names);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Config {
        statistics{

            public Object getConfigValue(Ehcache cache) {
                CacheConfiguration cacheConfig = cache.getCacheConfiguration();
                try {
                    Field field = cacheConfig.getClass().getDeclaredField("statistics");
                    field.setAccessible(true);
                    Boolean statistics = (Boolean)field.get(cacheConfig);
                    return statistics != null ? statistics.toString() : "na";
                }
                catch (Exception e) {
                    return "na";
                }
            }
        }
        ,
        evictionPolicy{

            public Object getConfigValue(Ehcache cache) {
                MemoryStoreEvictionPolicy policy = cache.getCacheConfiguration().getMemoryStoreEvictionPolicy();
                return policy.toString();
            }
        }
        ,
        maxElementsInMemory{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().getMaxElementsInMemory();
            }
        }
        ,
        maxElementsOnDisk{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().getMaxElementsOnDisk();
            }
        }
        ,
        timeToLiveSeconds{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().getTimeToLiveSeconds();
            }
        }
        ,
        timeToIdleSeconds{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().getTimeToIdleSeconds();
            }
        }
        ,
        eternal{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().isEternal();
            }
        }
        ,
        diskPersistent{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().isDiskPersistent();
            }
        }
        ,
        overflowToDisk{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().isOverflowToDisk();
            }
        }
        ,
        diskExpiryThreadIntervalSeconds{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds();
            }
        }
        ,
        diskSpoolBufferSizeMB{

            public Object getConfigValue(Ehcache cache) {
                return cache.getCacheConfiguration().getDiskSpoolBufferSizeMB();
            }
        };


        public abstract Object getConfigValue(Ehcache var1);
    }
}

