/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common.rest;

import java.util.List;
import java.util.Stack;
import org.terracotta.ehcachedx.monitor.common.rest.ResponseBuilder;
import org.terracotta.ehcachedx.monitor.common.rest.ResponseElement;
import org.terracotta.ehcachedx.monitor.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextResponseBuilder
implements ResponseBuilder {
    @Override
    public String construct(ResponseElement root) {
        if (root.hasValue()) {
            return String.valueOf(root.getValue());
        }
        if (root.hasChildren()) {
            StringBuilder result = new StringBuilder();
            Stack<List<ResponseElement>> childrenStack = new Stack<List<ResponseElement>>();
            childrenStack.add(root.getChildren());
            block0: while (!childrenStack.isEmpty()) {
                List children;
                while ((children = (List)childrenStack.peek()).isEmpty()) {
                    childrenStack.pop();
                    if (!childrenStack.isEmpty()) continue;
                }
                while (!children.isEmpty()) {
                    ResponseElement child = (ResponseElement)children.remove(0);
                    result.append(StringUtils.repeat("    ", childrenStack.size() - 1));
                    this.appendName(result, child);
                    if (child.hasValue()) {
                        if (child.hasRawValue()) {
                            this.appendRawValue(result, childrenStack, child);
                            continue;
                        }
                        this.appendSingleValue(result, child);
                        continue;
                    }
                    if (child.hasChildren()) {
                        result.append("\n");
                        childrenStack.push(child.getChildren());
                        continue block0;
                    }
                    result.append("\n");
                }
            }
            return result.toString();
        }
        return "";
    }

    private void appendName(StringBuilder result, ResponseElement child) {
        if (child.hasName()) {
            result.append(child.getName());
            result.append(":");
        }
    }

    private void appendRawValue(StringBuilder result, Stack<List<ResponseElement>> childrenStack, ResponseElement child) {
        result.append("\n");
        String value = String.valueOf(child.getValue());
        if (value.length() > 0) {
            for (String line : value.split("\n")) {
                result.append(StringUtils.repeat("    ", childrenStack.size()));
                result.append(line);
                result.append("\n");
            }
        }
    }

    private void appendSingleValue(StringBuilder result, ResponseElement child) {
        if (child.hasName()) {
            result.append(" ");
        }
        result.append(child.getValue());
        result.append("\n");
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }
}

