/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common;

import java.io.IOException;
import java.net.InetAddress;
import org.terracotta.ehcachedx.monitor.common.DxException;
import org.terracotta.ehcachedx.monitor.common.Service;
import org.terracotta.ehcachedx.monitor.common.handler.LicenseHandler;
import org.terracotta.ehcachedx.monitor.common.rest.RestMethod;
import org.terracotta.ehcachedx.monitor.common.rest.RestRequest;
import org.terracotta.ehcachedx.monitor.common.rest.RestResponse;
import org.terracotta.ehcachedx.monitor.common.rest.Visibility;

public class LifeCycleService {
    private volatile Service service;
    private volatile LicenseHandler licenseHandler;

    public LifeCycleService(Service service, LicenseHandler licenseHandler) {
        this.service = service;
        this.licenseHandler = licenseHandler;
    }

    public void stop() {
        this.service = null;
        this.licenseHandler = null;
    }

    @RestMethod(visibility=Visibility.PRIVATE)
    public void isLicensed(RestResponse response) {
        response.value(this.licenseHandler.isLicensed());
    }

    @RestMethod(visibility=Visibility.PRIVATE)
    public void getLicenseType(RestResponse response) {
        response.value(this.licenseHandler.getLicenseType());
    }

    @RestMethod(required={}, optional={}, visibility=Visibility.PRIVATE, description="Hidden shutdown")
    public void shutdown(RestRequest request, RestResponse response) throws IOException {
        if (request.getRemoteAddr().equals("127.0.0.1") || request.getRemoteAddr().equals("0:0:0:0:0:0:0:1%0") || request.getRemoteAddr().equals(InetAddress.getLocalHost().getHostAddress())) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        LifeCycleService.this.service.stop();
                    }
                    catch (DxException e) {
                        System.err.println("Couldn't shut service down!");
                        e.printStackTrace(System.err);
                    }
                }
            });
            response.value(true);
            response.outputResponse();
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        } else {
            response.value(false);
        }
    }
}

