/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.common;

import java.io.IOException;
import org.terracotta.ehcachedx.monitor.common.rest.RestMethod;
import org.terracotta.ehcachedx.monitor.common.rest.RestResponse;
import org.terracotta.ehcachedx.monitor.common.rest.Visibility;
import org.terracotta.ehcachedx.org.mortbay.jetty.Request;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.UserRealm;

public class AuthenticationService {
    private final UserRealm[] realms;

    public AuthenticationService(UserRealm[] realms) {
        this.realms = realms;
    }

    public boolean authenticate(Request request) {
        String pUserName = request.getParameter("user");
        String pPassword = request.getParameter("password");
        boolean success = true;
        if (this.isEnabled() && this.realms != null && this.realms.length > 0) {
            success = false;
            for (UserRealm realm : this.realms) {
                if (realm.authenticate(pUserName, pPassword, request) == null) continue;
                success = true;
                break;
            }
        }
        return success;
    }

    @RestMethod(visibility=Visibility.PRIVATE)
    public void isSecured(RestResponse response) throws IOException {
        response.value(this.isEnabled());
    }

    private boolean isEnabled() {
        return this.realms != null && this.realms.length > 0;
    }
}

