/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.license;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.license.Capabilities;
import org.terracotta.ehcachedx.license.Capability;
import org.terracotta.ehcachedx.license.EnterpriseLicense;
import org.terracotta.ehcachedx.license.License;
import org.terracotta.ehcachedx.license.util.Base64;
import org.terracotta.ehcachedx.license.util.EhcacheLicenseFormat;
import org.terracotta.ehcachedx.license.util.IOUtils;
import org.terracotta.ehcachedx.license.util.LicenseDescriptor;
import org.terracotta.ehcachedx.license.util.LicenseException;
import org.terracotta.ehcachedx.license.util.LicenseNotFoundException;
import org.terracotta.ehcachedx.license.util.LicenseProcessingException;
import org.terracotta.ehcachedx.license.util.TerracottaSigner;

public class LicenseResolver {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseResolver.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final long DEFAULT_TEMP_LICENSE_LIFETIME = 259200000L;
    public static final String RESOURCE_PREFIX = "resource:";
    public static final String BASE64_PREFIX = "base64:";
    private final String licenseDeclaration;
    private License license;

    public LicenseResolver(String licenseDeclaration) {
        this.licenseDeclaration = licenseDeclaration;
    }

    public License getLicense() {
        return this.license;
    }

    public String getLicenseText() {
        StringWriter out = new StringWriter();
        new EhcacheLicenseFormat().store(this.license, new PrintWriter(out));
        return out.toString();
    }

    private String getLicenseDeclarationForDisplay() {
        if (this.licenseDeclaration.startsWith(RESOURCE_PREFIX)) {
            return this.licenseDeclaration.substring(RESOURCE_PREFIX.length());
        }
        if (this.licenseDeclaration.startsWith(BASE64_PREFIX)) {
            return null;
        }
        return this.licenseDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveLicense() throws LicenseProcessingException {
        block13: {
            try {
                if (this.licenseDeclaration == null) break block13;
                InputStream licenseStream = null;
                licenseStream = this.licenseDeclaration.startsWith(RESOURCE_PREFIX) ? this.getLicenseStreamFromResource(this.licenseDeclaration.substring(RESOURCE_PREFIX.length())) : (this.licenseDeclaration.startsWith(BASE64_PREFIX) ? LicenseResolver.getLicenseStreamFromBase64(this.licenseDeclaration.substring(BASE64_PREFIX.length())) : LicenseResolver.getLicenseStreamFromPath(this.licenseDeclaration));
                if (licenseStream == null) {
                    throw new AssertionError((Object)"licenseStream is null");
                }
                try {
                    this.license = new EhcacheLicenseFormat().load(licenseStream);
                    TerracottaSigner signer = new TerracottaSigner();
                    if (!signer.verify(this.license.getCanonicalData(), this.license.getSignature())) {
                        throw new LicenseProcessingException(this.getLicenseDeclarationForDisplay(), "License key signature verification failed. Please contact sales@terracottatech.com for a valid key. A temporary license will be used.");
                    }
                    if (this.license.isExpired()) {
                        LOG.error("Your Ehcache Monitor license key has expired on " + this.license.expirationDate() + ". Please contact sales@terracottatech.com for a new license key.");
                    }
                }
                catch (LicenseException e) {
                    throw new LicenseProcessingException(this.getLicenseDeclarationForDisplay(), "Error while parsing license key.", e);
                }
                catch (IOException e) {
                    throw new LicenseProcessingException(this.getLicenseDeclarationForDisplay(), "Error while reading license key.", e);
                }
                finally {
                    IOUtils.closeQuietly(licenseStream);
                }
            }
            finally {
                if (null == this.license) {
                    LOG.warn("No Ehcache Monitor license key found. This monitoring probe software is not licensed for production usage, and is only licensed for development usage. See LICENSE.txt for details. A temporary key will be generated for development usage. When the temporary key expires, the Ehcache monitoring probe capability will be suspended but your ability to continue to use Ehcache will not be affected. Please contact sales@terracottatech.com to request a license.");
                    this.license = LicenseResolver.generateDevOnlyLicense();
                }
                this.logLicense();
            }
        }
    }

    private void logLicense() {
        String licenseInfo = LINE_SEPARATOR + "--------- Ehcache Monitor license key ---------" + LINE_SEPARATOR + this.license + "-----------------------------------------------";
        LOG.info(licenseInfo);
    }

    public boolean isMonitorSupported() {
        return this.isCapabilitySupported(Capability.MONITOR);
    }

    public boolean isCapabilitySupported(Capability capability) {
        if (this.license.isExpired()) {
            if ("DevOnly".equals(this.license.licenseType())) {
                LOG.error("Your Ehcache Monitor license key has expired. The Ehcache monitoring probe capability will be suspended until restarted. Ehcache will not be affected. For a license for use in production please contact sales@terracottatech.com.");
            } else {
                LOG.error("Your Ehcache Monitor license key has expired. The Ehcache monitoring probe capability will be suspended. Ehcache will not be affected. For a license for use in production please contact sales@terracottatech.com.");
            }
            return false;
        }
        Capabilities capabilities = this.license.capabilities();
        if (!capabilities.isSupported(capability)) {
            LOG.error("Ehcache Monitor does not support feature '" + (Object)((Object)capability) + "'" + ". Please contact sales@terracottatech.com for details.");
            return false;
        }
        if (!capabilities.isLicensed(capability)) {
            LOG.error("Your Ehcache Monitor license key doesn't allow feature '" + (Object)((Object)capability) + "'. Please contact sales@terracottatech.com for details.");
            return false;
        }
        return true;
    }

    private static License generateDevOnlyLicense() {
        Date expirationDate = new Date(System.currentTimeMillis() + 259200000L);
        LicenseDescriptor ld = new LicenseDescriptor();
        Capabilities tempLicenseCapabilities = new Capabilities(ld.getLicensedCapabilities("Ehcache Monitor"), ld.getEnterpriseCapabilities());
        EnterpriseLicense tempLicense = new EnterpriseLicense("DevOnly", "0", "DevOnly User", "Ehcache Monitor", expirationDate, tempLicenseCapabilities);
        return tempLicense;
    }

    private InputStream getLicenseStreamFromResource(String resource) throws LicenseProcessingException {
        if (resource == null || resource.trim().length() == 0) {
            throw new LicenseProcessingException(this.getLicenseDeclarationForDisplay(), "Resource path to license key empty or null");
        }
        String resourceFromRoot = resource.startsWith("/") ? resource : "/" + resource;
        InputStream in = LicenseResolver.class.getResourceAsStream(resourceFromRoot);
        if (in == null) {
            throw new LicenseNotFoundException("No license key found at resource path: " + resource);
        }
        LOG.info("License file found in resource: " + resource);
        return in;
    }

    private static InputStream getLicenseStreamFromBase64(String content) {
        return new ByteArrayInputStream(Base64.decode(content));
    }

    private static InputStream getLicenseStreamFromPath(String path) throws LicenseProcessingException {
        if (path == null) {
            throw new LicenseProcessingException("Path to license key is null");
        }
        try {
            FileInputStream in = new FileInputStream(path);
            LOG.info("License file found at: " + path);
            return in;
        }
        catch (FileNotFoundException e) {
            throw new LicenseNotFoundException("Can't find license key at path: " + path);
        }
    }
}

