/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.com.javabi.sizeof.definition;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Set;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinitionMap;
import org.terracotta.ehcachedx.com.javabi.sizeof.MemoryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedListDefinition
extends ClassDefinition<LinkedList> {
    private final Field headerField = LinkedList.class.getDeclaredField("header");
    private final Class entryClass;
    private final Field elementField;
    private final Field nextField;

    public LinkedListDefinition() throws ClassNotFoundException, NoSuchFieldException {
        this.headerField.setAccessible(true);
        this.entryClass = Class.forName("java.util.LinkedList$Entry");
        this.elementField = this.entryClass.getDeclaredField("element");
        this.elementField.setAccessible(true);
        this.nextField = this.entryClass.getDeclaredField("next");
        this.nextField.setAccessible(true);
    }

    @Override
    public long sizeOf(LinkedList list) {
        if (list == null) {
            return 0L;
        }
        return 44L + (long)list.size() * 24L;
    }

    @Override
    public final boolean hasElements(LinkedList list) {
        return true;
    }

    @Override
    public long sizeOfElements(LinkedList list, ClassDefinitionMap definitionMap, Set<Object> instanceSet, long size) throws IllegalAccessException {
        if (list == null) {
            return 0L;
        }
        int listSize = list.size();
        Object link = this.headerField.get(list);
        if (link == null) {
            return 0L;
        }
        instanceSet.add(link);
        for (int i = 0; i < listSize && (link = this.nextField.get(link)) != null; ++i) {
            instanceSet.add(link);
            Object element = this.elementField.get(link);
            if (element == null) continue;
            size += MemoryUtil.sizeOf(element, definitionMap, instanceSet);
        }
        return size;
    }
}

