/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.com.javabi.sizeof;

import java.io.PrintStream;
import java.util.Set;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinition;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinitionMap;
import org.terracotta.ehcachedx.com.javabi.sizeof.IdentityHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryUtil {
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_BOOLEAN = 1;
    public static final int SIZE_OF_CHAR = 2;
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_DOUBLE = 8;
    public static final int SIZE_OF_NULL_POINTER = 4;
    public static final int SIZE_OF_OBJECT_INSTANCE = 8;

    public static final long total() {
        return Runtime.getRuntime().totalMemory();
    }

    public static final long max() {
        return Runtime.getRuntime().maxMemory();
    }

    public static final long free() {
        return Runtime.getRuntime().freeMemory();
    }

    public static final long used() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private static final long roundUp(long size) {
        if (size % 8L == 0L) {
            return size;
        }
        return (size / 8L + 1L) * 8L;
    }

    public static final <T> long sizeOf(T object, ClassDefinitionMap definitionMap, Set<Object> instanceSet) throws IllegalAccessException {
        if (object == null) {
            return 0L;
        }
        if (instanceSet != null && !instanceSet.add(object)) {
            return 0L;
        }
        Class<?> type = object.getClass();
        ClassDefinition<?> definition = definitionMap.get(type);
        long size = definition.sizeOf(object);
        if (definition.hasElements(object)) {
            size = definition.sizeOfElements(object, definitionMap, instanceSet, size);
        }
        size = MemoryUtil.roundUp(size);
        return size;
    }

    public static final long sizeOf(Object object) throws IllegalAccessException {
        if (object == null) {
            return 0L;
        }
        return MemoryUtil.sizeOf(object, new ClassDefinitionMap(), new IdentityHashSet());
    }

    public static final <T> long sizeOfDebug(T object, ClassDefinitionMap definitionMap, Set<Object> instanceSet, PrintStream stream) throws IllegalAccessException {
        if (object == null) {
            return 0L;
        }
        if (instanceSet != null && !instanceSet.add(object)) {
            return 0L;
        }
        Class<?> type = object.getClass();
        ClassDefinition<?> definition = definitionMap.get(type);
        long rawSize = definition.sizeOfDebug(object, definitionMap, instanceSet, stream);
        long roundedSize = MemoryUtil.roundUp(rawSize);
        return roundedSize;
    }

    public static final long sizeOfDebug(Object object, PrintStream stream) throws IllegalAccessException {
        if (object == null) {
            return 0L;
        }
        return MemoryUtil.sizeOfDebug(object, new ClassDefinitionMap(), new IdentityHashSet(), stream);
    }

    private MemoryUtil() {
    }
}

