/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.com.javabi.sizeof;

import java.io.PrintStream;
import java.util.Set;
import org.terracotta.ehcachedx.com.javabi.sizeof.ClassDefinitionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassDefinition<I> {
    protected static final long sizeOfPrimitive(Class<?> type) {
        if (type.equals(Boolean.TYPE)) {
            return 1L;
        }
        if (type.equals(Character.TYPE)) {
            return 2L;
        }
        if (type.equals(Byte.TYPE)) {
            return 1L;
        }
        if (type.equals(Short.TYPE)) {
            return 2L;
        }
        if (type.equals(Integer.TYPE)) {
            return 4L;
        }
        if (type.equals(Long.TYPE)) {
            return 8L;
        }
        if (type.equals(Float.TYPE)) {
            return 4L;
        }
        if (type.equals(Double.TYPE)) {
            return 8L;
        }
        throw new IllegalArgumentException("type is not primitive: " + type);
    }

    protected static final long sizeOfLongArray(long length) {
        return 16L + length * 8L;
    }

    protected static final long sizeOfIntArray(long length) {
        if (length <= 1L) {
            return 16L;
        }
        return 16L + --length / 2L * 8L + (long)(length % 2L == 0L ? 0 : 8);
    }

    protected static final long sizeOfShortArray(long length) {
        if (length <= 2L) {
            return 16L;
        }
        return 16L + (length -= 2L) / 4L * 8L + (long)(length % 4L == 0L ? 0 : 8);
    }

    protected static final long sizeOfByteArray(long length) {
        if (length <= 4L) {
            return 16L;
        }
        return 16L + (length -= 4L) / 8L * 8L + (long)(length % 8L == 0L ? 0 : 8);
    }

    public abstract long sizeOf(I var1);

    public boolean hasElements(I instance) {
        return false;
    }

    public long sizeOfElements(I instance, ClassDefinitionMap definitionMap, Set<Object> instanceSet, long size) throws IllegalAccessException {
        throw new IllegalStateException("no elements");
    }

    public long sizeOfDebug(I instance, ClassDefinitionMap definitionMap, Set<Object> instanceSet, PrintStream stream) throws IllegalAccessException {
        throw new IllegalStateException("not implemented for class: " + instance.getClass());
    }
}

