/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package org.terracotta.ehcachedx.monitor.probe.counter.sampled;

import org.terracotta.ehcachedx.monitor.probe.counter.Counter;

import java.util.concurrent.Callable;

public class PullSampledCounterConfig extends SampledCounterConfig {

    private final boolean calculateDifference;
    private final Callable<Long> callable;

    public PullSampledCounterConfig(SampledCounterConfig config, boolean calculateDifference, Callable<Long> callable) {
        super(config.getIntervalSecs(), config.getHistorySize(), false, config.getInitialValue());
        this.calculateDifference = calculateDifference;
        this.callable = callable;
    }

    public boolean getCalculateDifference() {
        return calculateDifference;
    }

    public Callable<Long> getCallable() {
        return callable;
    }

    @Override
    public Counter createCounter() {
        return new PullSampledCounterImpl(this);
    }
}
