/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package org.terracotta.ehcachedx.monitor.probe;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

/**
 * Used by CacheManagerService
 */
public class SampledCacheStatisticsWrapper implements CacheEventListener {

    private final SampledCacheStatistics stats;

    public SampledCacheStatisticsWrapper(SampledCacheStatistics stats) {
        this.stats = stats;
    }

    public SampledCacheStatistics getStats() {
        return stats;
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        stats.notifyElementRemoved(ehcache, element);
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        stats.notifyElementPut(ehcache, element);
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        stats.notifyElementUpdated(ehcache, element);
    }

    public void notifyElementExpired(Ehcache ehcache, Element element) {
        stats.notifyElementExpired(ehcache, element);
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
        stats.notifyElementEvicted(ehcache, element);
    }

    public void notifyRemoveAll(Ehcache ehcache) {
        stats.notifyRemoveAll(ehcache);
    }

    public void dispose() {
        stats.dispose();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}
