/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright notice.  All rights reserved.
 */
package org.terracotta.ehcachedx.monitor.probe;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.util.PropertyUtil;

import java.net.UnknownHostException;
import java.util.Properties;

import static org.terracotta.ehcachedx.monitor.util.StringUtils.convertToInt;

/**
 * This is the entry point for the probe. It is started by the ehcache CacheManager.
 *
 * Note sampling 
 *
 */
public class ProbePeerListenerFactory extends CacheManagerPeerListenerFactory {
    public static final String PROPERTY_PROBE_ADDRESS = "probeAddress";
    public static final String PROPERTY_PROBE_PORT = "probePort";
    public static final String PROPERTY_PROBE_NAME = "probeName";
    public static final String PROPERTY_SERVER_ADDRESS = "monitorAddress";
    public static final String PROPERTY_SERVER_PORT = "monitorPort";
    public static final String PROPERTY_MEMORY_MEASUREMENT = "memoryMeasurement";

    @Override
    public CacheManagerPeerListener createCachePeerListener(CacheManager cacheManager, Properties properties) {
        String probeAddress = PropertyUtil.extractAndLogProperty(PROPERTY_PROBE_ADDRESS, properties);
        Integer probePort = convertToInt(PropertyUtil.extractAndLogProperty(PROPERTY_PROBE_PORT, properties));
        String probeName = PropertyUtil.extractAndLogProperty(PROPERTY_PROBE_NAME, properties);
        String monitorAddress = PropertyUtil.extractAndLogProperty(PROPERTY_SERVER_ADDRESS, properties);
        Integer monitorPort = convertToInt(PropertyUtil.extractAndLogProperty(PROPERTY_SERVER_PORT, properties));
        String memoryMeasurementString = PropertyUtil.extractAndLogProperty(PROPERTY_MEMORY_MEASUREMENT, properties);
        Boolean memoryMeasurement = parseBooleanWithDefaultToTrue(memoryMeasurementString);

        CacheManagerPeerListener listener;
        try {
            listener = new ProbePeerListener(new ProbeDxService.Config(
                    probeAddress, probePort, probeName, monitorAddress, monitorPort, true, memoryMeasurement), cacheManager);
        } catch (UnknownHostException e) {
            throw new CacheException("Unable to create ProbePeerListener. Initial cause was " + e.getMessage(), e);
        }
        return listener;
    }




    /**
     * Null safe, parser of boolean from a String
     * @param value
     * @return true if non null and case insensitively matches true
     */
    public static boolean parseBooleanWithDefaultToTrue(String value) {
        return value == null || value.equalsIgnoreCase("true");
    }






}