/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.org.apache.commons.math.stat.descriptive;

import org.terracotta.org.apache.commons.math.MathRuntimeException;
import org.terracotta.org.apache.commons.math.stat.descriptive.UnivariateStatistic;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    public double evaluate(double[] values) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length);
    }

    public abstract double evaluate(double[] var1, int var2, int var3);

    public abstract UnivariateStatistic copy();

    protected boolean test(double[] values, int begin, int length) {
        if (values == null) {
            throw MathRuntimeException.createIllegalArgumentException((String)"input values array is null", (Object[])new Object[0]);
        }
        if (begin < 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"start position cannot be negative ({0})", (Object[])new Object[]{begin});
        }
        if (length < 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"length cannot be negative ({0})", (Object[])new Object[]{length});
        }
        if (begin + length > values.length) {
            throw MathRuntimeException.createIllegalArgumentException((String)"subarray ends after array end", (Object[])new Object[0]);
        }
        return length != 0;
    }
}

