/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.org.mortbay.jetty.handler;

import java.io.IOException;
import org.terracotta.ehcachedx.javax.servlet.ServletException;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletRequest;
import org.terracotta.ehcachedx.javax.servlet.http.HttpServletResponse;
import org.terracotta.ehcachedx.org.mortbay.jetty.Request;
import org.terracotta.ehcachedx.org.mortbay.jetty.RequestLog;
import org.terracotta.ehcachedx.org.mortbay.jetty.Response;
import org.terracotta.ehcachedx.org.mortbay.jetty.Server;
import org.terracotta.ehcachedx.org.mortbay.jetty.handler.HandlerWrapper;
import org.terracotta.ehcachedx.org.mortbay.log.Log;

public class RequestLogHandler
extends HandlerWrapper {
    private RequestLog _requestLog;

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        super.handle(target, request, response, dispatch);
        if (dispatch == 1 && this._requestLog != null) {
            this._requestLog.log((Request)request, (Response)response);
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        try {
            if (this._requestLog != null) {
                this._requestLog.stop();
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._requestLog, requestLog, "logimpl", true);
        }
        this._requestLog = requestLog;
        try {
            if (this.isStarted() && this._requestLog != null) {
                this._requestLog.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setServer(Server server) {
        if (this._requestLog != null) {
            if (this.getServer() != null && this.getServer() != server) {
                this.getServer().getContainer().update((Object)this, this._requestLog, null, "logimpl", true);
            }
            super.setServer(server);
            if (server != null && server != this.getServer()) {
                server.getContainer().update((Object)this, null, this._requestLog, "logimpl", true);
            }
        } else {
            super.setServer(server);
        }
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._requestLog != null) {
            this._requestLog.start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._requestLog != null) {
            this._requestLog.stop();
        }
    }
}

