/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.org.mortbay.jetty;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.terracotta.ehcachedx.javax.servlet.ServletException;
import org.terracotta.ehcachedx.org.mortbay.component.Container;
import org.terracotta.ehcachedx.org.mortbay.component.LifeCycle;
import org.terracotta.ehcachedx.org.mortbay.jetty.Connector;
import org.terracotta.ehcachedx.org.mortbay.jetty.Handler;
import org.terracotta.ehcachedx.org.mortbay.jetty.HttpConnection;
import org.terracotta.ehcachedx.org.mortbay.jetty.HttpGenerator;
import org.terracotta.ehcachedx.org.mortbay.jetty.bio.SocketConnector;
import org.terracotta.ehcachedx.org.mortbay.jetty.handler.HandlerCollection;
import org.terracotta.ehcachedx.org.mortbay.jetty.handler.HandlerWrapper;
import org.terracotta.ehcachedx.org.mortbay.log.Log;
import org.terracotta.ehcachedx.org.mortbay.thread.QueuedThreadPool;
import org.terracotta.ehcachedx.org.mortbay.thread.ThreadPool;
import org.terracotta.ehcachedx.org.mortbay.util.Attributes;
import org.terracotta.ehcachedx.org.mortbay.util.AttributesMap;
import org.terracotta.ehcachedx.org.mortbay.util.LazyList;
import org.terracotta.ehcachedx.org.mortbay.util.MultiException;

public class Server
extends HandlerWrapper
implements Attributes {
    public static final String UNKNOWN_VERSION = "6.1.x";
    public static final String SNAPSHOT_VERSION = "6.1-SNAPSHOT";
    private static ShutdownHookThread hookThread = new ShutdownHookThread();
    private static String _version = Server.class.getPackage() != null && Server.class.getPackage().getImplementationVersion() != null ? Server.class.getPackage().getImplementationVersion() : "6.1.x";
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private Container _container = new Container();
    private boolean _sendServerVersion = true;
    private boolean _sendDateHeader = false;
    private AttributesMap _attributes = new AttributesMap();
    private List _dependentLifeCycles = new ArrayList();
    private int _graceful = 0;

    public Server() {
        this.setServer(this);
    }

    public Server(String host, int port) {
        this.setServer(this);
        SocketConnector connector = new SocketConnector();
        connector.setHost(host);
        connector.setPort(port);
        this.setConnectors(new Connector[]{connector});
    }

    public static String getVersion() {
        return _version;
    }

    public Container getContainer() {
        return this._container;
    }

    public boolean getStopAtShutdown() {
        return hookThread.contains(this);
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            hookThread.add(this);
        } else {
            hookThread.remove(this);
        }
    }

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.addToArray(this.getConnectors(), connector, Connector.class));
    }

    public void removeConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.removeFromArray(this.getConnectors(), connector));
    }

    public void setConnectors(Connector[] connectors) {
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                connectors[i].setServer(this);
            }
        }
        this._container.update((Object)this, this._connectors, connectors, "connector");
        this._connectors = connectors;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._container.update((Object)this, this._threadPool, threadPool, "threadpool", true);
        this._threadPool = threadPool;
    }

    protected void doStart() throws Exception {
        Log.debug("jetty-" + _version);
        HttpGenerator.setServerVersion(_version);
        MultiException mex = new MultiException();
        Iterator itor = this._dependentLifeCycles.iterator();
        while (itor.hasNext()) {
            try {
                ((LifeCycle)itor.next()).start();
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        if (this._threadPool == null) {
            QueuedThreadPool tp = new QueuedThreadPool();
            this.setThreadPool(tp);
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).start();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            super.doStart();
        }
        catch (Throwable e) {
            Log.warn("Error starting handlers", e);
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    protected void doStop() throws Exception {
        hookThread.remove(this);
        MultiException mex = new MultiException();
        if (this._graceful > 0) {
            if (this._connectors != null) {
                int i = this._connectors.length;
                while (i-- > 0) {
                    Log.debug("Graceful shutdown {}", this._connectors[i]);
                    try {
                        this._connectors[i].close();
                    }
                    catch (Throwable e) {
                        mex.add(e);
                    }
                }
            }
            Handler[] contexts = this.getChildHandlersByClass(Graceful.class);
            for (int c = 0; c < contexts.length; ++c) {
                Graceful context = (Graceful)((Object)contexts[c]);
                Log.debug("Graceful shutdown {}", context);
                context.setShutdown(true);
            }
            Thread.sleep(this._graceful);
        }
        if (this._connectors != null) {
            int i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).stop();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (!this._dependentLifeCycles.isEmpty()) {
            ListIterator itor = this._dependentLifeCycles.listIterator(this._dependentLifeCycles.size());
            while (itor.hasPrevious()) {
                try {
                    ((LifeCycle)itor.previous()).stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    public void handle(HttpConnection connection) throws IOException, ServletException {
        String target = connection.getRequest().getPathInfo();
        if (Log.isDebugEnabled()) {
            Log.debug("REQUEST " + target + " on " + connection);
            this.handle(target, connection.getRequest(), connection.getResponse(), 1);
            Log.debug("RESPONSE " + target + "  " + connection.getResponse().getStatus());
        } else {
            this.handle(target, connection.getRequest(), connection.getResponse(), 1);
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendDateHeader(boolean sendDateHeader) {
        this._sendDateHeader = sendDateHeader;
    }

    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    public void addLifeCycle(LifeCycle c) {
        if (c == null) {
            return;
        }
        if (!this._dependentLifeCycles.contains(c)) {
            this._dependentLifeCycles.add(c);
            this._container.addBean(c);
        }
        try {
            if (this.isStarted()) {
                c.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeLifeCycle(LifeCycle c) {
        if (c == null) {
            return;
        }
        this._dependentLifeCycles.remove(c);
        this._container.removeBean(c);
    }

    public void addHandler(Handler handler) {
        if (this.getHandler() == null) {
            this.setHandler(handler);
        } else if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).addHandler(handler);
        } else {
            HandlerCollection collection = new HandlerCollection();
            collection.setHandlers(new Handler[]{this.getHandler(), handler});
            this.setHandler(collection);
        }
    }

    public void removeHandler(Handler handler) {
        if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).removeHandler(handler);
        }
    }

    public Handler[] getHandlers() {
        if (this.getHandler() instanceof HandlerCollection) {
            return ((HandlerCollection)this.getHandler()).getHandlers();
        }
        return null;
    }

    public void setHandlers(Handler[] handlers) {
        HandlerCollection collection;
        if (this.getHandler() instanceof HandlerCollection) {
            collection = (HandlerCollection)this.getHandler();
        } else {
            collection = new HandlerCollection();
            this.setHandler(collection);
        }
        collection.setHandlers(handlers);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    public int getGracefulShutdown() {
        return this._graceful;
    }

    public void setGracefulShutdown(int timeoutMS) {
        this._graceful = timeoutMS;
    }

    public static interface Graceful {
        public void setShutdown(boolean var1);
    }

    private static class ShutdownHookThread
    extends Thread {
        private final AtomicBoolean hooked = new AtomicBoolean(false);
        private final ArrayList<Server> servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            block3: {
                if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked.get()) {
                    try {
                        Method shutdownHook = Runtime.class.getMethod("addShutdownHook", Thread.class);
                        shutdownHook.invoke((Object)Runtime.getRuntime(), this);
                        this.hooked.set(true);
                    }
                    catch (Exception e) {
                        if (!Log.isDebugEnabled()) break block3;
                        Log.debug("No shutdown hook in JVM ", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Server server) {
            this.createShutdownHook();
            ShutdownHookThread shutdownHookThread = this;
            synchronized (shutdownHookThread) {
                return this.servers.add(server);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Server server) {
            if (!this.hooked.get()) {
                return false;
            }
            ShutdownHookThread shutdownHookThread = this;
            synchronized (shutdownHookThread) {
                return this.servers.contains(server);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection c) {
            this.createShutdownHook();
            ShutdownHookThread shutdownHookThread = this;
            synchronized (shutdownHookThread) {
                return this.servers.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.createShutdownHook();
            ShutdownHookThread shutdownHookThread = this;
            synchronized (shutdownHookThread) {
                this.servers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Server server) {
            if (!this.hooked.get()) {
                return false;
            }
            this.createShutdownHook();
            ShutdownHookThread shutdownHookThread = this;
            synchronized (shutdownHookThread) {
                return this.servers.remove(server);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            if (!this.hooked.get()) {
                return false;
            }
            this.createShutdownHook();
            ShutdownHookThread shutdownHookThread = this;
            synchronized (shutdownHookThread) {
                return this.servers.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<Server> serversCopy;
            this.setName("Shutdown");
            Log.debug("Shutdown hook executing");
            ShutdownHookThread shutdownHookThread = this;
            synchronized (shutdownHookThread) {
                serversCopy = new ArrayList<Server>(this.servers);
            }
            for (Server svr : serversCopy) {
                if (svr == null) continue;
                try {
                    svr.stop();
                }
                catch (Exception e) {
                    Log.warn(e);
                }
                Log.debug("Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
        }
    }
}

