/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.util;

import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.monitor.util.ExceptionUtils;
import org.terracotta.ehcachedx.monitor.util.HttpUtils;

public abstract class RestProxy {
    private static final Logger LOG = LoggerFactory.getLogger(RestProxy.class);

    public static String registerProbe(String address, Integer port, String probeName, String probeHandlerName, String monitorAddress, Integer monitorPort) throws IOException {
        ArrayList<String> paramsAndValuesList = new ArrayList<String>();
        paramsAndValuesList.add("address");
        paramsAndValuesList.add(String.valueOf(address));
        paramsAndValuesList.add("port");
        paramsAndValuesList.add(String.valueOf(port));
        if (probeName != null) {
            paramsAndValuesList.add("probename");
            paramsAndValuesList.add(probeName);
        }
        if (probeHandlerName != null) {
            paramsAndValuesList.add("probehandlername");
            paramsAndValuesList.add(probeHandlerName);
        }
        String[] paramsAndValues = new String[paramsAndValuesList.size()];
        paramsAndValuesList.toArray(paramsAndValues);
        int registrationDelay = HttpUtils.getConnectionTimeoutSeconds();
        String result = null;
        while (true) {
            try {
                result = HttpUtils.getHttpConnectionContent(monitorAddress, monitorPort, RestProxy.prefix("registerProbe"), paramsAndValues);
                break;
            }
            catch (IOException e) {
                LOG.warn("Error connecting to the server at address '" + monitorAddress + "' and port '" + monitorPort + "', retrying in " + registrationDelay + " seconds ...");
                LOG.debug(ExceptionUtils.getExceptionStackTrace(e));
                try {
                    Thread.sleep(registrationDelay * 1000);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                    break;
                }
            }
        }
        if (null == result) {
            LOG.error("Gave up connecting to server at address '" + monitorAddress + "' and port '" + monitorPort + "'.");
        }
        return result;
    }

    public static boolean shutdown(String address, int port, String userName, String password) throws IOException {
        if (userName != null && userName.length() > 0 && password != null && password.length() > 0) {
            return Boolean.valueOf(HttpUtils.getHttpConnectionContent(address, port, RestProxy.prefix("shutdown"), "user", userName, "password", password));
        }
        return Boolean.valueOf(HttpUtils.getHttpConnectionContent(address, port, RestProxy.prefix("shutdown"), new String[0]));
    }

    public static String checkProbe(String address, Integer port, String challenge) throws IOException {
        return HttpUtils.getHttpConnectionContent(address, port, RestProxy.prefix("checkProbe"), "challenge", challenge);
    }

    public static String prefix(String method) {
        return "/monitor/" + method;
    }
}

