/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.monitor.util.StringUtils;

public abstract class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);
    public static final String PROPERTY_CONNECTION_TIMEOUT_SECONDS = "ehcachedx.connection.timeout.seconds";
    public static final int DEFAULT_CONNECTION_TIMEOUT_SECONDS = 30;
    public static final String CHAR_SET = "charset=";
    public static final Pattern CHAR_SET_PATTERN = Pattern.compile(";\\s*charset=(.*)$");

    public static String getHttpConnectionContent(String address, int port, String path, String ... paramsAndValues) throws IOException {
        final String[] result = new String[]{""};
        HttpUtils.performHttpConnectionRequest(address, port, path, paramsAndValues, new Handler(){

            public void handleConnectionContent(HttpURLConnection connection) throws IOException {
                result[0] = HttpUtils.getConnectionContent(connection);
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performHttpConnectionRequest(String address, int port, String path, String[] paramsAndValues, Handler handler) throws IOException {
        StringBuilder file = new StringBuilder(path);
        if (paramsAndValues != null && paramsAndValues.length > 0) {
            file.append("?");
            boolean needsSeparator = false;
            boolean param = true;
            for (String paramOrValue : paramsAndValues) {
                if (param) {
                    if (needsSeparator) {
                        file.append("&");
                    }
                    param = false;
                } else {
                    file.append("=");
                    param = true;
                    needsSeparator = true;
                }
                file.append(StringUtils.encodeUrl(String.valueOf(paramOrValue)));
            }
        }
        int timeout = HttpUtils.getConnectionTimeoutSeconds() * 1000;
        URL clientUrl = new URL("http", address, port, file.toString());
        LOG.debug("clientUrl: {}", clientUrl);
        HttpURLConnection clientConnection = (HttpURLConnection)clientUrl.openConnection();
        clientConnection.setConnectTimeout(timeout);
        clientConnection.setReadTimeout(timeout);
        clientConnection.setUseCaches(false);
        clientConnection.setDoInput(true);
        clientConnection.setDoOutput(true);
        clientConnection.connect();
        try {
            if (handler != null) {
                handler.handleConnectionContent(clientConnection);
            }
        }
        finally {
            clientConnection.disconnect();
        }
    }

    public static String getConnectionContent(HttpURLConnection connection) throws IOException {
        ByteArrayOutputStream byteOutput;
        Matcher contentTypeMatcher;
        String charSet = "ISO-8859-1";
        String contentType = connection.getContentType();
        if (contentType != null && (contentTypeMatcher = CHAR_SET_PATTERN.matcher(contentType)).find()) {
            charSet = contentTypeMatcher.group(1);
        }
        if (!HttpUtils.getConnectionContent(connection, byteOutput = new ByteArrayOutputStream())) {
            return null;
        }
        byte[] bytes = byteOutput.toByteArray();
        return new String(bytes, charSet);
    }

    public static boolean getConnectionContent(HttpURLConnection connection, OutputStream output) throws IOException {
        InputStream input;
        try {
            input = connection.getResponseCode() != 200 ? connection.getErrorStream() : connection.getInputStream();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        List<String> contentEncoding = headerFields.get("Content-Encoding");
        if (contentEncoding != null && contentEncoding.contains("gzip")) {
            input = new GZIPInputStream(input);
        }
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            output.write(buffer, 0, count);
        } while (-1 != (count = bufferedInput.read(buffer, 0, buffer.length)));
        return true;
    }

    public static int getConnectionTimeoutSeconds() {
        return Integer.valueOf(System.getProperty(PROPERTY_CONNECTION_TIMEOUT_SECONDS, String.valueOf(30)));
    }

    public static abstract class Handler {
        public abstract void handleConnectionContent(HttpURLConnection var1) throws IOException;
    }
}

