/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe.counter.sampled.memory;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.com.javabi.sizeof.MemoryUtil;
import org.terracotta.org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.terracotta.org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;

public class MemorySamplerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MemorySamplerSupport.class);
    private static final int WINDOW_SIZE = 100;
    private final DescriptiveStatistics stats;
    private boolean memoryMeasurement;

    public MemorySamplerSupport(boolean memoryMeasurement) {
        this.memoryMeasurement = memoryMeasurement;
        this.stats = new SynchronizedDescriptiveStatistics(100);
    }

    public void notifyMemorySampler(Ehcache ehcache, Element element, Long counter) {
        if (this.shouldSample(ehcache, counter)) {
            this.sample(element);
        }
    }

    public boolean shouldSample(Ehcache ehcache, Long putCounter) {
        return putCounter % 100L == 0L || putCounter <= 15L;
    }

    public Long getLastAdjustedSample() {
        return Math.round(this.stats.getPercentile(97.0));
    }

    public DescriptiveStatistics getStatistics() {
        return this.stats;
    }

    protected void recordValue(long size) {
        if (size != 0L) {
            this.stats.addValue(size);
        } else {
            this.stats.clear();
        }
    }

    public long sample(Object obj) {
        long val = this.estimateSize(obj);
        this.recordValue(val);
        return val;
    }

    protected long estimateSize(Object element) {
        long valueInBytes = 0L;
        if (Boolean.getBoolean("tc.active")) {
            return 0L;
        }
        if (!this.memoryMeasurement) {
            return 0L;
        }
        try {
            valueInBytes = MemoryUtil.sizeOf(element);
        }
        catch (Throwable t) {
            LOG.debug("Could not calculate memory for Element " + element + ". Returning 0", t);
            return 0L;
        }
        return valueInBytes;
    }
}

