/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe.counter;

import java.util.Timer;
import org.terracotta.ehcachedx.monitor.probe.counter.Counter;
import org.terracotta.ehcachedx.monitor.probe.counter.CounterConfig;
import org.terracotta.ehcachedx.monitor.probe.counter.CounterManager;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.SampledCounterImpl;

public class CounterManagerImpl
implements CounterManager {
    private final Timer timer = new Timer("CounterManagerImpl Timer", true);
    private boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        try {
            this.timer.cancel();
        }
        finally {
            this.shutdown = true;
        }
    }

    public synchronized Counter createCounter(CounterConfig config) {
        if (this.shutdown) {
            throw new IllegalStateException("counter manager is shut down");
        }
        if (config == null) {
            throw new NullPointerException("config cannot be null");
        }
        Counter counter = config.createCounter();
        if (counter instanceof SampledCounterImpl) {
            SampledCounterImpl sampledCounter = (SampledCounterImpl)counter;
            this.timer.schedule(sampledCounter.getTimerTask(), sampledCounter.getIntervalMillis(), sampledCounter.getIntervalMillis());
        }
        return counter;
    }
}

