/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

public class SampleRange {
    private int firstSample;
    private int lastSample;
    private int numSamples;

    public SampleRange(long fromTimeSeconds, int timeInterval, int sampleRate, int offset, int maxSample) {
        this.numSamples = timeInterval / sampleRate + 1;
        if (fromTimeSeconds == 0L) {
            this.lastSample = maxSample;
            this.firstSample = this.lastSample - this.numSamples + 1;
        } else {
            long currentTimeSeconds = System.currentTimeMillis() / 1000L;
            int samplesAgo = (int)((currentTimeSeconds - fromTimeSeconds) / (long)sampleRate);
            this.firstSample = maxSample - samplesAgo + 1;
            this.lastSample = this.firstSample + this.numSamples - 1;
        }
        if (offset == 1) {
            this.firstSample += this.numSamples - 1;
            this.lastSample += this.numSamples - 1;
        } else if (offset == -1) {
            this.firstSample -= this.numSamples - 1;
            this.lastSample -= this.numSamples - 1;
        }
        if (this.lastSample > maxSample) {
            this.lastSample = maxSample;
            this.firstSample = this.lastSample - this.numSamples + 1;
        }
        if (this.firstSample < 0) {
            this.firstSample = 0;
            this.lastSample = this.firstSample + this.numSamples - 1;
            if (this.lastSample > maxSample) {
                this.lastSample = maxSample;
            }
        }
        this.numSamples = this.lastSample - this.firstSample + 1;
    }

    public int getFirstSample() {
        return this.firstSample;
    }

    public int getLastSample() {
        return this.lastSample;
    }

    public int getNumSamples() {
        return this.numSamples;
    }
}

