/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

import java.net.UnknownHostException;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.terracotta.ehcachedx.monitor.probe.ProbeDxService;
import org.terracotta.ehcachedx.monitor.probe.ProbePeerListener;
import org.terracotta.ehcachedx.monitor.util.StringUtils;

public class ProbePeerListenerFactory
extends CacheManagerPeerListenerFactory {
    public static final String PROPERTY_PROBE_ADDRESS = "probeAddress";
    public static final String PROPERTY_PROBE_PORT = "probePort";
    public static final String PROPERTY_PROBE_NAME = "probeName";
    public static final String PROPERTY_SERVER_ADDRESS = "monitorAddress";
    public static final String PROPERTY_SERVER_PORT = "monitorPort";
    public static final String PROPERTY_MEMORY_MEASUREMENT = "memoryMeasurement";

    public CacheManagerPeerListener createCachePeerListener(CacheManager cacheManager, Properties properties) {
        ProbePeerListener listener;
        String probeAddress = PropertyUtil.extractAndLogProperty((String)PROPERTY_PROBE_ADDRESS, (Properties)properties);
        Integer probePort = StringUtils.convertToInt(PropertyUtil.extractAndLogProperty((String)PROPERTY_PROBE_PORT, (Properties)properties));
        String probeName = PropertyUtil.extractAndLogProperty((String)PROPERTY_PROBE_NAME, (Properties)properties);
        String monitorAddress = PropertyUtil.extractAndLogProperty((String)PROPERTY_SERVER_ADDRESS, (Properties)properties);
        Integer monitorPort = StringUtils.convertToInt(PropertyUtil.extractAndLogProperty((String)PROPERTY_SERVER_PORT, (Properties)properties));
        String memoryMeasurementString = PropertyUtil.extractAndLogProperty((String)PROPERTY_MEMORY_MEASUREMENT, (Properties)properties);
        Boolean memoryMeasurement = ProbePeerListenerFactory.parseBooleanWithDefaultToTrue(memoryMeasurementString);
        try {
            listener = new ProbePeerListener(new ProbeDxService.Config(probeAddress, probePort, probeName, monitorAddress, monitorPort, true, memoryMeasurement), cacheManager);
        }
        catch (UnknownHostException e) {
            throw new CacheException("Unable to create ProbePeerListener. Initial cause was " + e.getMessage(), (Throwable)e);
        }
        return listener;
    }

    public static boolean parseBooleanWithDefaultToTrue(String value) {
        return value == null || value.equalsIgnoreCase("true");
    }
}

