/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import org.terracotta.ehcachedx.monitor.common.DxException;
import org.terracotta.ehcachedx.monitor.common.handler.RestHandler;
import org.terracotta.ehcachedx.monitor.probe.CacheManagerService;
import org.terracotta.ehcachedx.monitor.probe.ProbeDxService;

public class ProbePeerListener
implements CacheManagerPeerListener {
    public static final String SCHEME_PROBE = "Probe";
    private volatile CacheManagerService cacheManagerService;
    private volatile ProbeDxService service;
    private Status status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProbePeerListener(ProbeDxService.Config config, CacheManager cacheManager) throws UnknownHostException {
        this.service = new ProbeDxService(config);
        this.service.setDaemon(true);
        ProbePeerListener probePeerListener = this;
        this.cacheManagerService = new CacheManagerService(probePeerListener.service.createCounterConfig(), cacheManager, config.isMemoryMeasurement());
        String cacheManagerName = cacheManager.getName();
        if (cacheManagerName.startsWith(CacheManager.class.getName())) {
            cacheManagerName = cacheManagerName.substring(CacheManager.class.getPackage().getName().length() + 1);
        }
        this.service.init(cacheManagerName, new RestHandler<CacheManagerService>(this.cacheManagerService, "probe"));
        ProbePeerListener probePeerListener2 = this;
        synchronized (probePeerListener2) {
            this.status = Status.STATUS_UNINITIALISED;
        }
    }

    public void init() throws CacheException {
        this.cacheManagerService.init();
        try {
            this.service.start();
        }
        catch (DxException e) {
            throw new CacheException("Unexpected error while starting the DX service.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws CacheException {
        try {
            this.service.stop();
        }
        catch (DxException e) {
            throw new CacheException("Unexpected error while stopping the DX service.", (Throwable)e);
        }
        this.service = null;
        this.cacheManagerService.shutdown();
        this.cacheManagerService = null;
        ProbePeerListener probePeerListener = this;
        synchronized (probePeerListener) {
            this.status = Status.STATUS_SHUTDOWN;
        }
    }

    public List getBoundCachePeers() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        ProbePeerListener probePeerListener = this;
        synchronized (probePeerListener) {
            if (Status.STATUS_UNINITIALISED == this.status && this.service != null && this.service.isRunning()) {
                this.status = Status.STATUS_ALIVE;
            }
            return this.status;
        }
    }

    public String getUniqueResourceIdentifier() {
        return ProbePeerListener.class.getName() + ":" + this.service.getPort();
    }

    public void attemptResolutionOfUniqueResourceConflict() throws IllegalStateException, CacheException {
        if (this.service != null) {
            this.service.assignFreePort(true);
        }
    }

    public String getScheme() {
        return SCHEME_PROBE;
    }

    public void notifyCacheAdded(String cacheName) {
        if (this.cacheManagerService != null) {
            this.cacheManagerService.registerCache(cacheName);
        }
    }

    public void notifyCacheRemoved(String cacheName) {
        if (this.cacheManagerService != null) {
            this.cacheManagerService.unregisterCache(cacheName);
        }
    }
}

