/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.monitor.common.AuthenticationService;
import org.terracotta.ehcachedx.monitor.common.DxException;
import org.terracotta.ehcachedx.monitor.common.GeneralService;
import org.terracotta.ehcachedx.monitor.common.LicenseService;
import org.terracotta.ehcachedx.monitor.common.LifeCycleService;
import org.terracotta.ehcachedx.monitor.common.Service;
import org.terracotta.ehcachedx.monitor.common.handler.AuthenticationHandler;
import org.terracotta.ehcachedx.monitor.common.handler.DxResourceHandler;
import org.terracotta.ehcachedx.monitor.common.handler.LicenseHandler;
import org.terracotta.ehcachedx.monitor.common.handler.RedirectHandler;
import org.terracotta.ehcachedx.monitor.common.handler.RestHandler;
import org.terracotta.ehcachedx.monitor.common.handler.RestHandlerList;
import org.terracotta.ehcachedx.monitor.probe.ProbeService;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.SampledCounterConfig;
import org.terracotta.ehcachedx.monitor.probe.util.PortUtils;
import org.terracotta.ehcachedx.monitor.util.ExceptionUtils;
import org.terracotta.ehcachedx.monitor.util.RestProxy;
import org.terracotta.ehcachedx.org.mortbay.jetty.Server;
import org.terracotta.ehcachedx.org.mortbay.jetty.handler.HandlerList;
import org.terracotta.ehcachedx.org.mortbay.resource.Resource;
import org.terracotta.ehcachedx.org.mortbay.thread.QueuedThreadPool;

public class ProbeDxService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(ProbeDxService.class);
    public static int PROBE_SAMPLING_INTERVAL_SECONDS = 10;
    public static final int PROBE_SAMPLING_HISTORY = 10;
    private final String address;
    private final String probeName;
    private final boolean bindStrictly;
    private final String monitorAddress;
    private final Integer monitorPort;
    private final RedirectHandler redirectHandler;
    private final LicenseHandler licenseHandler;
    private final LicenseService licenseService;
    private final LifeCycleService lifeCycleService;
    private final GeneralService generalService;
    private final Thread registerWithServer;
    private RestHandler probeHandler;
    private ProbeService probeService;
    private String probeHandlerName;
    private boolean daemon = false;
    private Server httpServer;
    private Integer port;
    private String userName;
    private String hashedPassword;
    private AuthenticationService authenticationService;

    public ProbeDxService(String address, int port) throws UnknownHostException {
        this(new Config().address(address).port(port));
    }

    public ProbeDxService(Config config) throws UnknownHostException {
        this.probeName = config.getName();
        this.bindStrictly = config.isBindStrictly();
        this.licenseHandler = new LicenseHandler();
        HashMap<String, String> redirects = new HashMap<String, String>();
        redirects.put("/", "/monitor");
        this.redirectHandler = new RedirectHandler(redirects);
        this.generalService = new GeneralService(10, PROBE_SAMPLING_INTERVAL_SECONDS);
        this.lifeCycleService = new LifeCycleService(this, this.licenseHandler);
        this.licenseService = new LicenseService();
        this.address = config.getAddress() != null && config.getAddress().length() != 0 ? config.getAddress() : this.calculateHostAddress();
        this.port = config.getPort();
        if (this.port == null || 0 == this.port) {
            this.assignFreePort(false);
        }
        this.monitorAddress = config.getServerAddress();
        this.monitorPort = config.getServerPort();
        this.registerWithServer = new Thread(new RegisterWithServer());
    }

    public synchronized boolean isDaemon() {
        return this.daemon;
    }

    public synchronized void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public static SampledCounterConfig createCounterConfig() {
        return new SampledCounterConfig(PROBE_SAMPLING_INTERVAL_SECONDS, 10, true, 0L);
    }

    public synchronized void init(String handlerName, RestHandler handler) {
        this.probeHandlerName = handlerName;
        this.probeHandler = handler;
        this.probeService = new ProbeService();
    }

    public String getAddress() {
        return this.address;
    }

    public synchronized Integer getPort() {
        return this.port;
    }

    public synchronized void assignFreePort(boolean forced) throws IllegalStateException {
        if (this.httpServer != null && this.httpServer.isStarting()) {
            throw new IllegalStateException("Cannot change the port of an already started DX service.");
        }
        this.port = PortUtils.getFreePort();
        if (forced) {
            LOG.warn("Resolving port conflict by automatically using a free TCP/IP port to listen on: " + this.port);
        } else {
            LOG.debug("Automatically finding a free TCP/IP port to listen on: " + this.port);
        }
    }

    private String calculateHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public synchronized void start() throws DxException {
        if (this.httpServer != null) {
            throw new DxException("The DX service has already been started beforehand.");
        }
        this.httpServer = new Server(this.bindStrictly ? this.address : null, this.port);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(3);
        threadPool.setDaemon(this.daemon);
        this.httpServer.setThreadPool(threadPool);
        this.httpServer.setStopAtShutdown(true);
        this.registerHandlers();
        this.startBackend();
        this.registerWithServer.start();
    }

    private synchronized void startBackend() throws DxException {
        try {
            this.httpServer.start();
            LOG.info("Started probe at http://" + this.address + ":" + this.port + "/monitor" + "/list");
            this.waitUntilRunning();
        }
        catch (Exception e) {
            throw new DxException("Unable to start Probe DX service for address '" + this.address + "' and port '" + this.port + "'.", e);
        }
    }

    private synchronized void registerHandlers() {
        HandlerList handlers = new HandlerList();
        handlers.addHandler(this.redirectHandler);
        DxResourceHandler resourceHandler = new DxResourceHandler();
        resourceHandler.setBaseResource(Resource.newClassPathResource("content"));
        handlers.addHandler(resourceHandler);
        RestHandlerList restHandlers = new RestHandlerList();
        restHandlers.addHandler(new RestHandler<ProbeService>(this.probeService));
        restHandlers.addHandler(new RestHandler<GeneralService>(this.generalService));
        restHandlers.addHandler(this.licenseHandler);
        restHandlers.addHandler(new RestHandler<LicenseService>(this.licenseService));
        this.authenticationService = new AuthenticationService(this.userName, this.hashedPassword);
        restHandlers.addHandler(new AuthenticationHandler(this.authenticationService));
        if (this.probeHandler != null) {
            restHandlers.addHandler(this.probeHandler);
        }
        restHandlers.addHandler(new RestHandler<LifeCycleService>(this.lifeCycleService));
        handlers.addHandler(restHandlers);
        this.httpServer.setHandler(handlers);
    }

    private synchronized boolean usesExternalServer() {
        return this.monitorAddress != null && this.monitorPort != null && (!this.monitorAddress.equals(this.address) || !this.monitorPort.equals(this.port));
    }

    public void waitUntilRunning() throws InterruptedException {
        while (!this.isRunning()) {
            Thread.sleep(100L);
        }
    }

    public synchronized boolean isRunning() {
        if (this.httpServer == null) {
            return false;
        }
        return this.httpServer.isStarted() && !this.registerWithServer.isAlive();
    }

    public synchronized void stop() throws DxException {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
                if (this.probeService != null) {
                    LOG.info("Stopped probe for " + this.address + ":" + this.port);
                } else {
                    LOG.info("Stopped monitor for " + this.address + ":" + this.port);
                }
            }
            catch (Exception e) {
                throw new DxException("Unable to stop the DX service.", e);
            }
            this.httpServer = null;
            this.lifeCycleService.stop();
        }
    }

    public LicenseHandler getLicenseHandler() {
        return this.licenseHandler;
    }

    public synchronized void setUserName(String userName) {
        this.userName = userName;
    }

    public synchronized void setHashedPassword(String hashedPassword) {
        this.hashedPassword = hashedPassword;
    }

    private class RegisterWithServer
    implements Runnable {
        private RegisterWithServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Integer localServerPort;
            String localServerAddress;
            String localProbeHandlerName;
            String localProbeName;
            Integer localPort;
            String localAddress;
            String response = null;
            ProbeDxService probeDxService = ProbeDxService.this;
            synchronized (probeDxService) {
                localAddress = ProbeDxService.this.address;
                localPort = ProbeDxService.this.port;
                localProbeName = ProbeDxService.this.probeName;
                localProbeHandlerName = ProbeDxService.this.probeHandlerName;
                localServerAddress = ProbeDxService.this.monitorAddress;
                localServerPort = ProbeDxService.this.monitorPort;
            }
            if (ProbeDxService.this.usesExternalServer()) {
                try {
                    response = RestProxy.registerProbe(localAddress, localPort, localProbeName, localProbeHandlerName, localServerAddress, localServerPort);
                    LOG.info("ProbeDXService Registered with monitor at address '" + localServerAddress + "' and port '" + localServerPort + "'");
                }
                catch (IOException e) {
                    LOG.error("Couldn't register ProbeDXService with monitor at address '" + localServerAddress + "' and port '" + localServerPort + "'\n" + ExceptionUtils.getExceptionStackTrace(e));
                }
            }
            String license = null;
            if (response != null && !"ok".equals(response)) {
                StringTokenizer tokenizer = new StringTokenizer(response.trim(), ":\n");
                while (tokenizer.hasMoreTokens()) {
                    String key = tokenizer.nextToken();
                    if (!tokenizer.hasMoreTokens()) continue;
                    String value = tokenizer.nextToken();
                    ProbeDxService probeDxService2 = ProbeDxService.this;
                    synchronized (probeDxService2) {
                        if ("user".equals(key.trim())) {
                            ProbeDxService.this.userName = value.trim();
                        } else if ("password".equals(key.trim())) {
                            ProbeDxService.this.hashedPassword = value.trim();
                        } else if ("license".equals(key.trim())) {
                            license = value.trim();
                        }
                    }
                }
            }
            if (license == null) {
                ProbeDxService.this.licenseHandler.registerLicense(null);
                LOG.info("Null license registered");
            } else {
                ProbeDxService.this.licenseHandler.registerLicense("base64:" + license);
                LOG.info("License obtained from Monitor and registered in probe: " + license);
            }
            ProbeDxService probeDxService3 = ProbeDxService.this;
            synchronized (probeDxService3) {
                if (ProbeDxService.this.authenticationService != null) {
                    ProbeDxService.this.authenticationService.setUserName(ProbeDxService.this.userName);
                    ProbeDxService.this.authenticationService.setPassword(ProbeDxService.this.hashedPassword);
                }
            }
        }
    }

    public static class Config {
        private String address;
        private Integer port;
        private String name;
        private String monitorAddress;
        private Integer monitorPort;
        private boolean bindStrictly;
        private boolean memoryMeasurement;

        public Config() {
        }

        public Config(String address, Integer port, String name, String monitorAddress, Integer monitorPort, boolean bindStrictly) {
            this.address(address);
            this.port(port);
            this.name(name);
            this.monitorAddress(monitorAddress);
            this.monitorPort(monitorPort);
            this.bindStrictly(bindStrictly);
            this.memoryMeasurement(true);
        }

        public Config(String address, Integer port, String name, String monitorAddress, Integer monitorPort, boolean bindStrictly, boolean memoryMeasurement) {
            this.address(address);
            this.port(port);
            this.name(name);
            this.monitorAddress(monitorAddress);
            this.monitorPort(monitorPort);
            this.bindStrictly(bindStrictly);
            this.memoryMeasurement(memoryMeasurement);
        }

        Config address(String address) {
            this.address = address;
            return this;
        }

        Config port(Integer port) {
            this.port = port;
            return this;
        }

        Config name(String name) {
            this.name = name;
            return this;
        }

        Config monitorAddress(String monitorAddress) {
            this.monitorAddress = monitorAddress;
            return this;
        }

        Config monitorPort(Integer monitorPort) {
            this.monitorPort = monitorPort;
            return this;
        }

        Config bindStrictly(boolean bindStrictly) {
            this.bindStrictly = bindStrictly;
            return this;
        }

        Config memoryMeasurement(boolean memoryMeasurement) {
            this.memoryMeasurement = memoryMeasurement;
            return this;
        }

        public String getAddress() {
            return this.address;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getName() {
            return this.name;
        }

        public String getServerAddress() {
            return this.monitorAddress;
        }

        public Integer getServerPort() {
            return this.monitorPort;
        }

        public boolean isBindStrictly() {
            return this.bindStrictly;
        }

        public boolean isMemoryMeasurement() {
            return this.memoryMeasurement;
        }
    }
}

