/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.monitor.probe;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.monitor.common.CacheManagerServiceAPI;
import org.terracotta.ehcachedx.monitor.common.rest.ResponseElement;
import org.terracotta.ehcachedx.monitor.common.rest.RestMethod;
import org.terracotta.ehcachedx.monitor.common.rest.RestRequest;
import org.terracotta.ehcachedx.monitor.common.rest.RestResponse;
import org.terracotta.ehcachedx.monitor.probe.CacheConfig;
import org.terracotta.ehcachedx.monitor.probe.ElementMetaData;
import org.terracotta.ehcachedx.monitor.probe.SampleHistoryEntry;
import org.terracotta.ehcachedx.monitor.probe.SampledCacheStatistics;
import org.terracotta.ehcachedx.monitor.probe.SampledCacheStatisticsWrapper;
import org.terracotta.ehcachedx.monitor.probe.Statistic;
import org.terracotta.ehcachedx.monitor.probe.counter.CounterManager;
import org.terracotta.ehcachedx.monitor.probe.counter.CounterManagerImpl;
import org.terracotta.ehcachedx.monitor.probe.counter.sampled.SampledCounterConfig;

public class CacheManagerService
implements CacheManagerServiceAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CacheManagerService.class);
    private static final String REPLICATION_MODE_RMI = "RMI";
    private static final String REPLICATION_MODE_JGROUPS = "JGroups";
    private static final String REPLICATION_MODE_JMS = "JMS";
    private static final String REPLICATION_MODE_CUSTOM = "Custom";
    private static final String REPLICATION_MODE_TERRACOTTA = "Terracotta";
    private static final String REPLICATION_MODE_NONE = "None";
    private static final String REPLICATION_MODE_MIXED = "Mixed";
    private final ConcurrentMap<String, SampledCacheStatisticsWrapper> cacheStatistics = new ConcurrentHashMap<String, SampledCacheStatisticsWrapper>();
    private final CounterManager counterManager = new CounterManagerImpl();
    private final SampledCounterConfig counterConfig;
    private final CacheManager cacheManager;
    private boolean memoryMeasurement;

    public CacheManagerService(SampledCounterConfig counterConfig, CacheManager cacheManager, boolean memoryMeasurement) {
        this.counterConfig = counterConfig;
        this.cacheManager = cacheManager;
        this.memoryMeasurement = memoryMeasurement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ConcurrentMap<String, SampledCacheStatisticsWrapper> concurrentMap = this.cacheStatistics;
        synchronized (concurrentMap) {
            for (String cacheName : this.cacheManager.getCacheNames()) {
                this.registerCache(cacheName);
            }
        }
    }

    public void shutdown() {
        this.counterManager.shutdown();
    }

    @RestMethod
    public void getCacheManagerName(RestResponse response) throws IOException {
        String cacheManagerName = this.cacheManager.getName();
        if (cacheManagerName.startsWith(CacheManager.class.getName() + "@")) {
            cacheManagerName = cacheManagerName.substring(CacheManager.class.getPackage().getName().length() + 1);
        }
        response.value(cacheManagerName);
    }

    @RestMethod
    public void getCacheManagerStatus(RestResponse response) throws IOException {
        response.value(this.cacheManager.getStatus().toString());
    }

    @RestMethod
    public void getCacheNames(RestResponse response) throws IOException {
        TreeSet<String> set = new TreeSet<String>(Arrays.asList(this.cacheManager.getCacheNames()));
        response.childType("name").children(set);
    }

    @RestMethod
    public void getCacheCount(RestResponse response) throws IOException {
        response.value(this.cacheManager.getCacheNames().length);
    }

    @RestMethod
    public void getReplicationMode(RestResponse response) throws IOException {
        String[] names;
        Collection<Object> providers;
        block21: {
            try {
                try {
                    Field field = this.cacheManager.getClass().getDeclaredField("cacheManagerPeerProvider");
                    field.setAccessible(true);
                    CacheManagerPeerProvider provider = (CacheManagerPeerProvider)field.get(this.cacheManager);
                    providers = new ArrayList();
                    if (provider != null) {
                        providers.add(provider);
                    }
                }
                catch (NoSuchFieldException e) {
                    Field field = this.cacheManager.getClass().getDeclaredField("cacheManagerPeerProviders");
                    field.setAccessible(true);
                    Map map = (Map)field.get(this.cacheManager);
                    if (map != null) {
                        providers = map.values();
                        break block21;
                    }
                    providers = Collections.emptyList();
                }
            }
            catch (Exception e) {
                LOG.error("Unsupported Ehcache version, can't detect the replication mode");
                response.value("unknown");
                return;
            }
        }
        HashSet<String> replicationModes = new HashSet<String>();
        for (CacheManagerPeerProvider cacheManagerPeerProvider : providers) {
            if (cacheManagerPeerProvider == null) continue;
            if (cacheManagerPeerProvider.getClass().getName().contains("RMICacheManagerPeerProvider")) {
                replicationModes.add(REPLICATION_MODE_RMI);
                continue;
            }
            if (cacheManagerPeerProvider.getClass().getName().contains("JGroupsCacheManagerPeerProvider")) {
                replicationModes.add(REPLICATION_MODE_JGROUPS);
                continue;
            }
            if (cacheManagerPeerProvider.getClass().getName().contains("JMSCacheManagerPeerProvider")) {
                replicationModes.add(REPLICATION_MODE_JMS);
                continue;
            }
            replicationModes.add(REPLICATION_MODE_CUSTOM);
        }
        if (Boolean.getBoolean("tc.active") && (names = this.cacheManager.getCacheNames()).length > 0) {
            for (String name : names) {
                Ehcache cache = this.cacheManager.getEhcache(name);
                CacheConfiguration config = cache.getCacheConfiguration();
                try {
                    Method method = CacheConfiguration.class.getDeclaredMethod("isTerracottaClustered", new Class[0]);
                    method.setAccessible(true);
                    Object result = method.invoke((Object)config, new Object[0]);
                    if (((Boolean)result).booleanValue()) {
                        replicationModes.add(REPLICATION_MODE_TERRACOTTA);
                        continue;
                    }
                    if (0 != replicationModes.size() && !replicationModes.contains(REPLICATION_MODE_TERRACOTTA)) continue;
                    replicationModes.add(REPLICATION_MODE_NONE);
                }
                catch (NoSuchMethodException e) {
                }
                catch (InvocationTargetException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        if (0 == replicationModes.size()) {
            response.value(REPLICATION_MODE_NONE);
        } else if (1 == replicationModes.size()) {
            response.value(replicationModes.iterator().next());
        } else {
            response.value(REPLICATION_MODE_MIXED);
        }
    }

    @RestMethod(required={"cache", "count"}, optional={"query"})
    public void getCacheKeys(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        String countString = request.getParameter("count");
        String query = request.getParameter("query");
        int count = Integer.parseInt(countString);
        if (count <= 0) {
            throw new IllegalArgumentException("count needs to be positive");
        }
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        response.childType("key");
        if (cache != null) {
            List keys = cache.getKeysWithExpiryCheck();
            Iterator it = keys.iterator();
            while (count > 0 && it.hasNext()) {
                Object key = it.next();
                if (null != query && !this.queryKey(key, query)) continue;
                --count;
                response.child(key);
            }
        }
    }

    @RestMethod
    public void getCacheElementMetaDataNames(RestRequest request, RestResponse response) throws IOException {
        response.childType("name").children(ElementMetaData.getNames());
    }

    @RestMethod(required={"cache", "key", "name"})
    public void getCacheElementMetaDataValue(RestRequest request, RestResponse response) throws IOException {
        Element element;
        String cacheName = request.getParameter("cache");
        String key = request.getParameter("key");
        String metaDataName = request.getParameter("name");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null && (element = cache.getQuiet((Serializable)((Object)key))) != null) {
            response.value(ElementMetaData.getMetaData(metaDataName, element));
        }
    }

    @RestMethod(required={"cache", "key", "name"})
    public void getCacheElementMetaDataValues(RestRequest request, RestResponse response) throws IOException {
        Element element;
        String cacheName = request.getParameter("cache");
        String key = request.getParameter("key");
        String[] metaDataNames = request.getParameterValues("name");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null && (element = cache.getQuiet((Serializable)((Object)key))) != null) {
            for (String name : metaDataNames) {
                String metaData = ElementMetaData.getMetaData(name, element);
                if (metaData == null) continue;
                response.child(name, metaData);
            }
        }
    }

    @RestMethod(required={"cache", "key"})
    public void getCacheElementMetaDataAllValues(RestRequest request, RestResponse response) throws IOException {
        Element element;
        String cacheName = request.getParameter("cache");
        String key = request.getParameter("key");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null && (element = cache.getQuiet((Serializable)((Object)key))) != null) {
            for (String name : ElementMetaData.getNames()) {
                response.child(name, ElementMetaData.getMetaData(name, element));
            }
        }
    }

    @RestMethod(required={"cache"})
    public void getCacheElementCount(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            response.value(cache.getSize());
        }
    }

    @RestMethod(required={"cache"})
    public void getCacheElementCountMemory(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            response.value(cache.getMemoryStoreSize());
        }
    }

    @RestMethod(required={"cache"})
    public void getCacheElementCountDisk(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            response.value(cache.getDiskStoreSize());
        }
    }

    @RestMethod(required={"cache"})
    public void getCacheElementMemorySize(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            response.value(cache.calculateInMemorySize());
        }
    }

    @RestMethod(required={"cache"})
    public void removeAllFromCache(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            cache.removeAll();
            response.ok();
        }
    }

    @RestMethod(required={"cache", "query"})
    public void removeQueryFromCache(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        String query = request.getParameter("query");
        int count = 0;
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            List keys = cache.getKeysWithExpiryCheck();
            for (Object key : keys) {
                if (!this.queryKey(key, query) || !cache.removeQuiet(key)) continue;
                ++count;
            }
            response.value(count);
        }
    }

    @RestMethod(required={"cache", "key"})
    public void removeFromCache(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        String key = request.getParameter("key");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            if (cache.removeQuiet((Serializable)((Object)key))) {
                response.value("removed");
            } else {
                response.value("key not found");
            }
        }
    }

    @RestMethod(required={"cache"})
    public void flushCache(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            cache.flush();
            response.ok();
        }
    }

    @RestMethod(required={"cache"})
    public void evictExpiredElements(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            cache.evictExpiredElements();
            response.ok();
        }
    }

    @RestMethod(required={"cache", "name"})
    public void getCacheConfigValue(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        String configName = request.getParameter("name");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            response.value(CacheConfig.getConfigValue(configName, cache));
        }
    }

    @RestMethod(required={"cache", "name"})
    public void getCacheConfigValues(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        String[] configNames = request.getParameterValues("name");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            for (String configName : configNames) {
                Object value = CacheConfig.getConfigValue(configName, cache);
                if (value == null) continue;
                response.child(configName, value);
            }
        }
    }

    @RestMethod(required={"cache"})
    public void getCacheConfigAllValues(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            for (String name : CacheConfig.getNames()) {
                response.child(name, CacheConfig.getConfigValue(name, cache));
            }
        }
    }

    @RestMethod
    public void getAllCachesConfigAllValues(RestResponse response) throws IOException {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            ResponseElement cacheElement = response.begin("cache");
            cacheElement.child("name", cacheName);
            ResponseElement configValuesElement = cacheElement.begin("configValues");
            for (String name : CacheConfig.getNames()) {
                configValuesElement.child(name, CacheConfig.getConfigValue(name, cache));
            }
            configValuesElement.end();
            cacheElement.end();
        }
    }

    @RestMethod
    public void getCacheConfigNames(RestRequest request, RestResponse response) throws IOException {
        response.childType("name").children(CacheConfig.getNames());
    }

    @RestMethod(required={"cache", "name"})
    public void getSampledStatisticValue(RestRequest request, RestResponse response) throws IOException {
        String result;
        String cacheName = request.getParameter("cache");
        String statName = request.getParameter("name");
        SampledCacheStatistics stats = this.getStats(cacheName);
        if (stats != null && (result = stats.getSample(statName)) != null) {
            response.value(result);
        }
    }

    @RestMethod(required={"cache", "name"})
    public void getSampledStatisticValues(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        String[] statNames = request.getParameterValues("name");
        SampledCacheStatistics stats = this.getStats(cacheName);
        if (stats != null) {
            for (String statName : statNames) {
                String result = stats.getSample(statName);
                if (result == null) continue;
                response.child(statName, result);
            }
        }
    }

    @RestMethod(required={"cache"})
    public void getSampledStatisticAllValues(RestRequest request, RestResponse response) throws IOException {
        String cacheName = request.getParameter("cache");
        SampledCacheStatistics stats = this.getStats(cacheName);
        if (stats != null) {
            for (String statName : Statistic.getNames()) {
                String result = stats.getSample(statName);
                if (result == null) continue;
                response.child(statName, result);
            }
        }
    }

    @RestMethod(required={"name"})
    public void getAllCachesSampledStatisticValues(RestRequest request, RestResponse response) throws IOException {
        String[] statNames = request.getParameterValues("name");
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            ResponseElement cacheElement = response.begin("cache");
            cacheElement.child("name", cacheName);
            ResponseElement sampledStatisticValuesElement = cacheElement.begin("sampledStatisticValues");
            SampledCacheStatistics stats = this.getStats(cacheName);
            if (stats != null) {
                for (String statName : statNames) {
                    String result = stats.getSample(statName);
                    if (result == null) continue;
                    sampledStatisticValuesElement.child(statName, result);
                }
            }
            sampledStatisticValuesElement.end();
            cacheElement.end();
        }
    }

    @RestMethod(required={"cache", "name"}, optional={"fromDateTime", "timeInterval", "offset"})
    public void getSampledStatisticHistory(RestRequest request, RestResponse response) throws IOException {
        SampledCacheStatistics stats;
        String cacheName = request.getParameter("cache");
        String statName = request.getParameter("name");
        String fromDateTime = request.getParameter("fromDateTime");
        String timeIntervalParam = request.getParameter("timeInterval");
        String offset = request.getParameter("offset");
        int sampleRate = this.counterConfig.getIntervalSecs();
        long fromTimeSeconds = 0L;
        if (fromDateTime != null) {
            String pattern = "yyyy/MM/dd HH:mm:ss";
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            df.setLenient(false);
            try {
                Date date = df.parse(fromDateTime);
                if (date.after(new Date())) {
                    throw new IllegalArgumentException("fromDateTime of '" + fromDateTime + "' cannot be in the future");
                }
                fromTimeSeconds = date.getTime() / 1000L;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Can't parse fromDateTimefield '" + fromDateTime + "' with pattern '" + pattern + "'");
            }
        }
        int timeInterval = 60;
        if (timeIntervalParam != null) {
            timeInterval = Integer.parseInt(timeIntervalParam);
        }
        if (timeInterval < sampleRate) {
            throw new IllegalArgumentException("timeInterval needs to be greater than or equal to the sample rate of " + sampleRate + " seconds");
        }
        if (timeInterval > 86400) {
            throw new IllegalArgumentException("timeInterval cannot be greater than " + sampleRate + " seconds (1 day)");
        }
        int offsetFactor = 0;
        if (offset != null) {
            if ("forward".equals(offset)) {
                offsetFactor = 1;
            } else if ("back".equals(offset)) {
                offsetFactor = -1;
            } else {
                throw new IllegalArgumentException("offset'" + offset + "'" + " must be either 'forward' or 'back'");
            }
        }
        if ((stats = this.getStats(cacheName)) != null) {
            for (SampleHistoryEntry entry : stats.getAggregatedSampleHistory(statName, fromTimeSeconds, timeInterval, sampleRate, offsetFactor)) {
                response.begin("sample").child("value", entry.getValue()).child("timestamp", entry.getDate()).end();
            }
        }
    }

    private SampledCacheStatistics getStats(String cacheName) {
        SampledCacheStatisticsWrapper wrapper = (SampledCacheStatisticsWrapper)this.cacheStatistics.get(cacheName);
        SampledCacheStatistics stats = null;
        if (wrapper != null) {
            stats = wrapper.getStats();
        }
        return stats;
    }

    private boolean queryKey(Object key, String query) {
        return String.valueOf(key).indexOf(query) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCache(String cacheName) {
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        RegisteredEventListeners listeners = cache.getCacheEventNotificationService();
        SampledCacheStatistics stats = new SampledCacheStatistics(cache, this.counterManager, this.counterConfig, this.memoryMeasurement);
        SampledCacheStatisticsWrapper wrapper = new SampledCacheStatisticsWrapper(stats);
        ConcurrentMap<String, SampledCacheStatisticsWrapper> concurrentMap = this.cacheStatistics;
        synchronized (concurrentMap) {
            listeners.registerListener((CacheEventListener)wrapper);
            this.cacheStatistics.put(cacheName, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCache(String cacheName) {
        RegisteredEventListeners listeners = null;
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            listeners = cache.getCacheEventNotificationService();
        }
        ConcurrentMap<String, SampledCacheStatisticsWrapper> concurrentMap = this.cacheStatistics;
        synchronized (concurrentMap) {
            SampledCacheStatisticsWrapper wrapper = (SampledCacheStatisticsWrapper)this.cacheStatistics.remove(cacheName);
            if (wrapper != null && listeners != null) {
                listeners.unregisterListener((CacheEventListener)wrapper);
            }
        }
    }

    public static SimpleDateFormat createMetaDataDateFormat() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }
}

